/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lambda.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.lambda.model.*;

import com.amazonaws.protocol.json.*;

/**
 * EventSourceMappingConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EventSourceMappingConfigurationJsonMarshaller {

    /**
     * Marshall the given parameter object, and output to a SdkJsonGenerator
     */
    public void marshall(EventSourceMappingConfiguration eventSourceMappingConfiguration, StructuredJsonGenerator jsonGenerator) {

        if (eventSourceMappingConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            jsonGenerator.writeStartObject();

            if (eventSourceMappingConfiguration.getUUID() != null) {
                jsonGenerator.writeFieldName("UUID").writeValue(eventSourceMappingConfiguration.getUUID());
            }
            if (eventSourceMappingConfiguration.getBatchSize() != null) {
                jsonGenerator.writeFieldName("BatchSize").writeValue(eventSourceMappingConfiguration.getBatchSize());
            }
            if (eventSourceMappingConfiguration.getEventSourceArn() != null) {
                jsonGenerator.writeFieldName("EventSourceArn").writeValue(eventSourceMappingConfiguration.getEventSourceArn());
            }
            if (eventSourceMappingConfiguration.getFunctionArn() != null) {
                jsonGenerator.writeFieldName("FunctionArn").writeValue(eventSourceMappingConfiguration.getFunctionArn());
            }
            if (eventSourceMappingConfiguration.getLastModified() != null) {
                jsonGenerator.writeFieldName("LastModified").writeValue(eventSourceMappingConfiguration.getLastModified());
            }
            if (eventSourceMappingConfiguration.getLastProcessingResult() != null) {
                jsonGenerator.writeFieldName("LastProcessingResult").writeValue(eventSourceMappingConfiguration.getLastProcessingResult());
            }
            if (eventSourceMappingConfiguration.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(eventSourceMappingConfiguration.getState());
            }
            if (eventSourceMappingConfiguration.getStateTransitionReason() != null) {
                jsonGenerator.writeFieldName("StateTransitionReason").writeValue(eventSourceMappingConfiguration.getStateTransitionReason());
            }

            jsonGenerator.writeEndObject();
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    private static EventSourceMappingConfigurationJsonMarshaller instance;

    public static EventSourceMappingConfigurationJsonMarshaller getInstance() {
        if (instance == null)
            instance = new EventSourceMappingConfigurationJsonMarshaller();
        return instance;
    }

}
