/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kinesis.model.transform;

import java.io.ByteArrayInputStream;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.*;
import com.amazonaws.transform.Marshaller;

import com.amazonaws.protocol.json.*;

/**
 * EnableEnhancedMonitoringRequest Marshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EnableEnhancedMonitoringRequestMarshaller implements Marshaller<Request<EnableEnhancedMonitoringRequest>, EnableEnhancedMonitoringRequest> {

    private final SdkJsonMarshallerFactory protocolFactory;

    public EnableEnhancedMonitoringRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<EnableEnhancedMonitoringRequest> marshall(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) {

        if (enableEnhancedMonitoringRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<EnableEnhancedMonitoringRequest> request = new DefaultRequest<EnableEnhancedMonitoringRequest>(enableEnhancedMonitoringRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.EnableEnhancedMonitoring");

        request.setHttpMethod(HttpMethodName.POST);

        request.setResourcePath("");

        try {
            final StructuredJsonGenerator jsonGenerator = protocolFactory.createGenerator();

            jsonGenerator.writeStartObject();

            if (enableEnhancedMonitoringRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(enableEnhancedMonitoringRequest.getStreamName());
            }

            com.amazonaws.internal.SdkInternalList<String> shardLevelMetricsList = (com.amazonaws.internal.SdkInternalList<String>) enableEnhancedMonitoringRequest
                    .getShardLevelMetrics();
            if (!shardLevelMetricsList.isEmpty() || !shardLevelMetricsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ShardLevelMetrics");
                jsonGenerator.writeStartArray();
                for (String shardLevelMetricsListValue : shardLevelMetricsList) {
                    if (shardLevelMetricsListValue != null) {
                        jsonGenerator.writeValue(shardLevelMetricsListValue);
                    }
                }
                jsonGenerator.writeEndArray();
            }

            jsonGenerator.writeEndObject();

            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", protocolFactory.getContentType());
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }

        return request;
    }

}
