/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.services.codepipeline.model.ActionConfigurationProperty;
import com.amazonaws.services.codepipeline.model.ActionTypeId;
import com.amazonaws.services.codepipeline.model.ActionTypeSettings;
import com.amazonaws.services.codepipeline.model.ArtifactDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ActionType
implements Serializable,
Cloneable {
    private ActionTypeId id;
    private ActionTypeSettings settings;
    private List<ActionConfigurationProperty> actionConfigurationProperties;
    private ArtifactDetails inputArtifactDetails;
    private ArtifactDetails outputArtifactDetails;

    public void setId(ActionTypeId id) {
        this.id = id;
    }

    public ActionTypeId getId() {
        return this.id;
    }

    public ActionType withId(ActionTypeId id) {
        this.setId(id);
        return this;
    }

    public void setSettings(ActionTypeSettings settings) {
        this.settings = settings;
    }

    public ActionTypeSettings getSettings() {
        return this.settings;
    }

    public ActionType withSettings(ActionTypeSettings settings) {
        this.setSettings(settings);
        return this;
    }

    public List<ActionConfigurationProperty> getActionConfigurationProperties() {
        return this.actionConfigurationProperties;
    }

    public void setActionConfigurationProperties(Collection<ActionConfigurationProperty> actionConfigurationProperties) {
        if (actionConfigurationProperties == null) {
            this.actionConfigurationProperties = null;
            return;
        }
        this.actionConfigurationProperties = new ArrayList<ActionConfigurationProperty>(actionConfigurationProperties);
    }

    public ActionType withActionConfigurationProperties(ActionConfigurationProperty ... actionConfigurationProperties) {
        if (this.actionConfigurationProperties == null) {
            this.setActionConfigurationProperties(new ArrayList<ActionConfigurationProperty>(actionConfigurationProperties.length));
        }
        for (ActionConfigurationProperty ele : actionConfigurationProperties) {
            this.actionConfigurationProperties.add(ele);
        }
        return this;
    }

    public ActionType withActionConfigurationProperties(Collection<ActionConfigurationProperty> actionConfigurationProperties) {
        this.setActionConfigurationProperties(actionConfigurationProperties);
        return this;
    }

    public void setInputArtifactDetails(ArtifactDetails inputArtifactDetails) {
        this.inputArtifactDetails = inputArtifactDetails;
    }

    public ArtifactDetails getInputArtifactDetails() {
        return this.inputArtifactDetails;
    }

    public ActionType withInputArtifactDetails(ArtifactDetails inputArtifactDetails) {
        this.setInputArtifactDetails(inputArtifactDetails);
        return this;
    }

    public void setOutputArtifactDetails(ArtifactDetails outputArtifactDetails) {
        this.outputArtifactDetails = outputArtifactDetails;
    }

    public ArtifactDetails getOutputArtifactDetails() {
        return this.outputArtifactDetails;
    }

    public ActionType withOutputArtifactDetails(ArtifactDetails outputArtifactDetails) {
        this.setOutputArtifactDetails(outputArtifactDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getActionConfigurationProperties() != null) {
            sb.append("ActionConfigurationProperties: ").append(this.getActionConfigurationProperties()).append(",");
        }
        if (this.getInputArtifactDetails() != null) {
            sb.append("InputArtifactDetails: ").append(this.getInputArtifactDetails()).append(",");
        }
        if (this.getOutputArtifactDetails() != null) {
            sb.append("OutputArtifactDetails: ").append(this.getOutputArtifactDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionType)) {
            return false;
        }
        ActionType other = (ActionType)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getActionConfigurationProperties() == null ^ this.getActionConfigurationProperties() == null) {
            return false;
        }
        if (other.getActionConfigurationProperties() != null && !other.getActionConfigurationProperties().equals(this.getActionConfigurationProperties())) {
            return false;
        }
        if (other.getInputArtifactDetails() == null ^ this.getInputArtifactDetails() == null) {
            return false;
        }
        if (other.getInputArtifactDetails() != null && !other.getInputArtifactDetails().equals(this.getInputArtifactDetails())) {
            return false;
        }
        if (other.getOutputArtifactDetails() == null ^ this.getOutputArtifactDetails() == null) {
            return false;
        }
        return other.getOutputArtifactDetails() == null || other.getOutputArtifactDetails().equals(this.getOutputArtifactDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getActionConfigurationProperties() == null ? 0 : this.getActionConfigurationProperties().hashCode());
        hashCode = 31 * hashCode + (this.getInputArtifactDetails() == null ? 0 : this.getInputArtifactDetails().hashCode());
        hashCode = 31 * hashCode + (this.getOutputArtifactDetails() == null ? 0 : this.getOutputArtifactDetails().hashCode());
        return hashCode;
    }

    public ActionType clone() {
        try {
            return (ActionType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

