/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateRepositoryNameRequestMarshaller
implements Marshaller<Request<UpdateRepositoryNameRequest>, UpdateRepositoryNameRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateRepositoryNameRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateRepositoryNameRequest> marshall(UpdateRepositoryNameRequest updateRepositoryNameRequest) {
        if (updateRepositoryNameRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateRepositoryNameRequest> request = new DefaultRequest<UpdateRepositoryNameRequest>(updateRepositoryNameRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.UpdateRepositoryName");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateRepositoryNameRequest.getOldName() != null) {
                jsonGenerator.writeFieldName("oldName").writeValue(updateRepositoryNameRequest.getOldName());
            }
            if (updateRepositoryNameRequest.getNewName() != null) {
                jsonGenerator.writeFieldName("newName").writeValue(updateRepositoryNameRequest.getNewName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

