/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.amplifybackend;

import javax.annotation.Generated;

import com.amazonaws.services.amplifybackend.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSAmplifyBackend}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAmplifyBackend implements AWSAmplifyBackend {

    protected AbstractAWSAmplifyBackend() {
    }

    @Override
    public CloneBackendResult cloneBackend(CloneBackendRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBackendResult createBackend(CreateBackendRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBackendAPIResult createBackendAPI(CreateBackendAPIRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBackendAuthResult createBackendAuth(CreateBackendAuthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBackendConfigResult createBackendConfig(CreateBackendConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTokenResult createToken(CreateTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBackendResult deleteBackend(DeleteBackendRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBackendAPIResult deleteBackendAPI(DeleteBackendAPIRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBackendAuthResult deleteBackendAuth(DeleteBackendAuthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTokenResult deleteToken(DeleteTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GenerateBackendAPIModelsResult generateBackendAPIModels(GenerateBackendAPIModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBackendResult getBackend(GetBackendRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBackendAPIResult getBackendAPI(GetBackendAPIRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBackendAPIModelsResult getBackendAPIModels(GetBackendAPIModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBackendAuthResult getBackendAuth(GetBackendAuthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBackendJobResult getBackendJob(GetBackendJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTokenResult getToken(GetTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBackendJobsResult listBackendJobs(ListBackendJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveAllBackendsResult removeAllBackends(RemoveAllBackendsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveBackendConfigResult removeBackendConfig(RemoveBackendConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBackendAPIResult updateBackendAPI(UpdateBackendAPIRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBackendAuthResult updateBackendAuth(UpdateBackendAuthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBackendConfigResult updateBackendConfig(UpdateBackendConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBackendJobResult updateBackendJob(UpdateBackendJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
