/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.directory.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.directory.model.*;

import com.amazonaws.protocol.json.*;

/**
 * SchemaExtensionInfoMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SchemaExtensionInfoJsonMarshaller {

    /**
     * Marshall the given parameter object, and output to a SdkJsonGenerator
     */
    public void marshall(SchemaExtensionInfo schemaExtensionInfo, StructuredJsonGenerator jsonGenerator) {

        if (schemaExtensionInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            jsonGenerator.writeStartObject();

            if (schemaExtensionInfo.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(schemaExtensionInfo.getDirectoryId());
            }
            if (schemaExtensionInfo.getSchemaExtensionId() != null) {
                jsonGenerator.writeFieldName("SchemaExtensionId").writeValue(schemaExtensionInfo.getSchemaExtensionId());
            }
            if (schemaExtensionInfo.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(schemaExtensionInfo.getDescription());
            }
            if (schemaExtensionInfo.getSchemaExtensionStatus() != null) {
                jsonGenerator.writeFieldName("SchemaExtensionStatus").writeValue(schemaExtensionInfo.getSchemaExtensionStatus());
            }
            if (schemaExtensionInfo.getSchemaExtensionStatusReason() != null) {
                jsonGenerator.writeFieldName("SchemaExtensionStatusReason").writeValue(schemaExtensionInfo.getSchemaExtensionStatusReason());
            }
            if (schemaExtensionInfo.getStartDateTime() != null) {
                jsonGenerator.writeFieldName("StartDateTime").writeValue(schemaExtensionInfo.getStartDateTime());
            }
            if (schemaExtensionInfo.getEndDateTime() != null) {
                jsonGenerator.writeFieldName("EndDateTime").writeValue(schemaExtensionInfo.getEndDateTime());
            }

            jsonGenerator.writeEndObject();
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    private static SchemaExtensionInfoJsonMarshaller instance;

    public static SchemaExtensionInfoJsonMarshaller getInstance() {
        if (instance == null)
            instance = new SchemaExtensionInfoJsonMarshaller();
        return instance;
    }

}
