/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResourceTag
implements Serializable,
Cloneable {
    private String resourceId;
    private SdkInternalList<Tag> tagsList;

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ResourceTag withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public List<Tag> getTagsList() {
        if (this.tagsList == null) {
            this.tagsList = new SdkInternalList();
        }
        return this.tagsList;
    }

    public void setTagsList(Collection<Tag> tagsList) {
        if (tagsList == null) {
            this.tagsList = null;
            return;
        }
        this.tagsList = new SdkInternalList<Tag>(tagsList);
    }

    public ResourceTag withTagsList(Tag ... tagsList) {
        if (this.tagsList == null) {
            this.setTagsList(new SdkInternalList<Tag>(tagsList.length));
        }
        for (Tag ele : tagsList) {
            this.tagsList.add(ele);
        }
        return this;
    }

    public ResourceTag withTagsList(Collection<Tag> tagsList) {
        this.setTagsList(tagsList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getTagsList() != null) {
            sb.append("TagsList: ").append(this.getTagsList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTag)) {
            return false;
        }
        ResourceTag other = (ResourceTag)obj;
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getTagsList() == null ^ this.getTagsList() == null) {
            return false;
        }
        return other.getTagsList() == null || other.getTagsList().equals(this.getTagsList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getTagsList() == null ? 0 : this.getTagsList().hashCode());
        return hashCode;
    }

    public ResourceTag clone() {
        try {
            return (ResourceTag)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

