/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.ListTasksRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListTasksRequestMarshaller
implements Marshaller<Request<ListTasksRequest>, ListTasksRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListTasksRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListTasksRequest> marshall(ListTasksRequest listTasksRequest) {
        if (listTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTasksRequest> request = new DefaultRequest<ListTasksRequest>(listTasksRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.ListTasks");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listTasksRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(listTasksRequest.getCluster());
            }
            if (listTasksRequest.getContainerInstance() != null) {
                jsonGenerator.writeFieldName("containerInstance").writeValue(listTasksRequest.getContainerInstance());
            }
            if (listTasksRequest.getFamily() != null) {
                jsonGenerator.writeFieldName("family").writeValue(listTasksRequest.getFamily());
            }
            if (listTasksRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listTasksRequest.getNextToken());
            }
            if (listTasksRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listTasksRequest.getMaxResults());
            }
            if (listTasksRequest.getStartedBy() != null) {
                jsonGenerator.writeFieldName("startedBy").writeValue(listTasksRequest.getStartedBy());
            }
            if (listTasksRequest.getServiceName() != null) {
                jsonGenerator.writeFieldName("serviceName").writeValue(listTasksRequest.getServiceName());
            }
            if (listTasksRequest.getDesiredStatus() != null) {
                jsonGenerator.writeFieldName("desiredStatus").writeValue(listTasksRequest.getDesiredStatus());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

