/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.ReferenceDataSource;
import com.amazonaws.services.kinesisanalytics.model.transform.S3ReferenceDataSourceJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.SourceSchemaJsonMarshaller;

public class ReferenceDataSourceJsonMarshaller {
    private static ReferenceDataSourceJsonMarshaller instance;

    public void marshall(ReferenceDataSource referenceDataSource, StructuredJsonGenerator jsonGenerator) {
        if (referenceDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (referenceDataSource.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(referenceDataSource.getTableName());
            }
            if (referenceDataSource.getS3ReferenceDataSource() != null) {
                jsonGenerator.writeFieldName("S3ReferenceDataSource");
                S3ReferenceDataSourceJsonMarshaller.getInstance().marshall(referenceDataSource.getS3ReferenceDataSource(), jsonGenerator);
            }
            if (referenceDataSource.getReferenceSchema() != null) {
                jsonGenerator.writeFieldName("ReferenceSchema");
                SourceSchemaJsonMarshaller.getInstance().marshall(referenceDataSource.getReferenceSchema(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ReferenceDataSourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ReferenceDataSourceJsonMarshaller();
        }
        return instance;
    }
}

