/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.auditmanager;

import javax.annotation.Generated;

import com.amazonaws.services.auditmanager.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSAuditManager}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAuditManager implements AWSAuditManager {

    protected AbstractAWSAuditManager() {
    }

    @Override
    public AssociateAssessmentReportEvidenceFolderResult associateAssessmentReportEvidenceFolder(AssociateAssessmentReportEvidenceFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchAssociateAssessmentReportEvidenceResult batchAssociateAssessmentReportEvidence(BatchAssociateAssessmentReportEvidenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchCreateDelegationByAssessmentResult batchCreateDelegationByAssessment(BatchCreateDelegationByAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteDelegationByAssessmentResult batchDeleteDelegationByAssessment(BatchDeleteDelegationByAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDisassociateAssessmentReportEvidenceResult batchDisassociateAssessmentReportEvidence(BatchDisassociateAssessmentReportEvidenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchImportEvidenceToAssessmentControlResult batchImportEvidenceToAssessmentControl(BatchImportEvidenceToAssessmentControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssessmentResult createAssessment(CreateAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssessmentFrameworkResult createAssessmentFramework(CreateAssessmentFrameworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssessmentReportResult createAssessmentReport(CreateAssessmentReportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateControlResult createControl(CreateControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssessmentResult deleteAssessment(DeleteAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssessmentFrameworkResult deleteAssessmentFramework(DeleteAssessmentFrameworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssessmentReportResult deleteAssessmentReport(DeleteAssessmentReportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteControlResult deleteControl(DeleteControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterAccountResult deregisterAccount(DeregisterAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterOrganizationAdminAccountResult deregisterOrganizationAdminAccount(DeregisterOrganizationAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateAssessmentReportEvidenceFolderResult disassociateAssessmentReportEvidenceFolder(DisassociateAssessmentReportEvidenceFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountStatusResult getAccountStatus(GetAccountStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssessmentResult getAssessment(GetAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssessmentFrameworkResult getAssessmentFramework(GetAssessmentFrameworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssessmentReportUrlResult getAssessmentReportUrl(GetAssessmentReportUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChangeLogsResult getChangeLogs(GetChangeLogsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetControlResult getControl(GetControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDelegationsResult getDelegations(GetDelegationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEvidenceResult getEvidence(GetEvidenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEvidenceByEvidenceFolderResult getEvidenceByEvidenceFolder(GetEvidenceByEvidenceFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEvidenceFolderResult getEvidenceFolder(GetEvidenceFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEvidenceFoldersByAssessmentResult getEvidenceFoldersByAssessment(GetEvidenceFoldersByAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEvidenceFoldersByAssessmentControlResult getEvidenceFoldersByAssessmentControl(GetEvidenceFoldersByAssessmentControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetOrganizationAdminAccountResult getOrganizationAdminAccount(GetOrganizationAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServicesInScopeResult getServicesInScope(GetServicesInScopeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSettingsResult getSettings(GetSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssessmentFrameworksResult listAssessmentFrameworks(ListAssessmentFrameworksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssessmentReportsResult listAssessmentReports(ListAssessmentReportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssessmentsResult listAssessments(ListAssessmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListControlsResult listControls(ListControlsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListKeywordsForDataSourceResult listKeywordsForDataSource(ListKeywordsForDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotificationsResult listNotifications(ListNotificationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterAccountResult registerAccount(RegisterAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterOrganizationAdminAccountResult registerOrganizationAdminAccount(RegisterOrganizationAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssessmentResult updateAssessment(UpdateAssessmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssessmentControlResult updateAssessmentControl(UpdateAssessmentControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssessmentControlSetStatusResult updateAssessmentControlSetStatus(UpdateAssessmentControlSetStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssessmentFrameworkResult updateAssessmentFramework(UpdateAssessmentFrameworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssessmentStatusResult updateAssessmentStatus(UpdateAssessmentStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateControlResult updateControl(UpdateControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSettingsResult updateSettings(UpdateSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ValidateAssessmentReportIntegrityResult validateAssessmentReportIntegrity(ValidateAssessmentReportIntegrityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
