/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.route53resolver;

import javax.annotation.Generated;

import com.amazonaws.services.route53resolver.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonRoute53Resolver}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonRoute53Resolver implements AmazonRoute53Resolver {

    protected AbstractAmazonRoute53Resolver() {
    }

    @Override
    public AssociateResolverEndpointIpAddressResult associateResolverEndpointIpAddress(AssociateResolverEndpointIpAddressRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateResolverQueryLogConfigResult associateResolverQueryLogConfig(AssociateResolverQueryLogConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateResolverRuleResult associateResolverRule(AssociateResolverRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResolverEndpointResult createResolverEndpoint(CreateResolverEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResolverQueryLogConfigResult createResolverQueryLogConfig(CreateResolverQueryLogConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResolverRuleResult createResolverRule(CreateResolverRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResolverEndpointResult deleteResolverEndpoint(DeleteResolverEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResolverQueryLogConfigResult deleteResolverQueryLogConfig(DeleteResolverQueryLogConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResolverRuleResult deleteResolverRule(DeleteResolverRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateResolverEndpointIpAddressResult disassociateResolverEndpointIpAddress(DisassociateResolverEndpointIpAddressRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateResolverQueryLogConfigResult disassociateResolverQueryLogConfig(DisassociateResolverQueryLogConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateResolverRuleResult disassociateResolverRule(DisassociateResolverRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverDnssecConfigResult getResolverDnssecConfig(GetResolverDnssecConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverEndpointResult getResolverEndpoint(GetResolverEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverQueryLogConfigResult getResolverQueryLogConfig(GetResolverQueryLogConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverQueryLogConfigAssociationResult getResolverQueryLogConfigAssociation(GetResolverQueryLogConfigAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverQueryLogConfigPolicyResult getResolverQueryLogConfigPolicy(GetResolverQueryLogConfigPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverRuleResult getResolverRule(GetResolverRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverRuleAssociationResult getResolverRuleAssociation(GetResolverRuleAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResolverRulePolicyResult getResolverRulePolicy(GetResolverRulePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolverDnssecConfigsResult listResolverDnssecConfigs(ListResolverDnssecConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolverEndpointIpAddressesResult listResolverEndpointIpAddresses(ListResolverEndpointIpAddressesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolverEndpointsResult listResolverEndpoints(ListResolverEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolverQueryLogConfigAssociationsResult listResolverQueryLogConfigAssociations(ListResolverQueryLogConfigAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolverQueryLogConfigsResult listResolverQueryLogConfigs(ListResolverQueryLogConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolverRuleAssociationsResult listResolverRuleAssociations(ListResolverRuleAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResolverRulesResult listResolverRules(ListResolverRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResolverQueryLogConfigPolicyResult putResolverQueryLogConfigPolicy(PutResolverQueryLogConfigPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResolverRulePolicyResult putResolverRulePolicy(PutResolverRulePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResolverDnssecConfigResult updateResolverDnssecConfig(UpdateResolverDnssecConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResolverEndpointResult updateResolverEndpoint(UpdateResolverEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResolverRuleResult updateResolverRule(UpdateResolverRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
