/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless;

import javax.annotation.Generated;

import com.amazonaws.services.iotwireless.model.*;

/**
 * Abstract implementation of {@code AWSIoTWirelessAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTWirelessAsync extends AbstractAWSIoTWireless implements AWSIoTWirelessAsync {

    protected AbstractAWSIoTWirelessAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateAwsAccountWithPartnerAccountResult> associateAwsAccountWithPartnerAccountAsync(
            AssociateAwsAccountWithPartnerAccountRequest request) {

        return associateAwsAccountWithPartnerAccountAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateAwsAccountWithPartnerAccountResult> associateAwsAccountWithPartnerAccountAsync(
            AssociateAwsAccountWithPartnerAccountRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateAwsAccountWithPartnerAccountRequest, AssociateAwsAccountWithPartnerAccountResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateWirelessDeviceWithThingResult> associateWirelessDeviceWithThingAsync(
            AssociateWirelessDeviceWithThingRequest request) {

        return associateWirelessDeviceWithThingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateWirelessDeviceWithThingResult> associateWirelessDeviceWithThingAsync(
            AssociateWirelessDeviceWithThingRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateWirelessDeviceWithThingRequest, AssociateWirelessDeviceWithThingResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateWirelessGatewayWithCertificateResult> associateWirelessGatewayWithCertificateAsync(
            AssociateWirelessGatewayWithCertificateRequest request) {

        return associateWirelessGatewayWithCertificateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateWirelessGatewayWithCertificateResult> associateWirelessGatewayWithCertificateAsync(
            AssociateWirelessGatewayWithCertificateRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateWirelessGatewayWithCertificateRequest, AssociateWirelessGatewayWithCertificateResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateWirelessGatewayWithThingResult> associateWirelessGatewayWithThingAsync(
            AssociateWirelessGatewayWithThingRequest request) {

        return associateWirelessGatewayWithThingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateWirelessGatewayWithThingResult> associateWirelessGatewayWithThingAsync(
            AssociateWirelessGatewayWithThingRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateWirelessGatewayWithThingRequest, AssociateWirelessGatewayWithThingResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDestinationResult> createDestinationAsync(CreateDestinationRequest request) {

        return createDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDestinationResult> createDestinationAsync(CreateDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDestinationRequest, CreateDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDeviceProfileResult> createDeviceProfileAsync(CreateDeviceProfileRequest request) {

        return createDeviceProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDeviceProfileResult> createDeviceProfileAsync(CreateDeviceProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDeviceProfileRequest, CreateDeviceProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateServiceProfileResult> createServiceProfileAsync(CreateServiceProfileRequest request) {

        return createServiceProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateServiceProfileResult> createServiceProfileAsync(CreateServiceProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateServiceProfileRequest, CreateServiceProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWirelessDeviceResult> createWirelessDeviceAsync(CreateWirelessDeviceRequest request) {

        return createWirelessDeviceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWirelessDeviceResult> createWirelessDeviceAsync(CreateWirelessDeviceRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWirelessDeviceRequest, CreateWirelessDeviceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWirelessGatewayResult> createWirelessGatewayAsync(CreateWirelessGatewayRequest request) {

        return createWirelessGatewayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWirelessGatewayResult> createWirelessGatewayAsync(CreateWirelessGatewayRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWirelessGatewayRequest, CreateWirelessGatewayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWirelessGatewayTaskResult> createWirelessGatewayTaskAsync(CreateWirelessGatewayTaskRequest request) {

        return createWirelessGatewayTaskAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWirelessGatewayTaskResult> createWirelessGatewayTaskAsync(CreateWirelessGatewayTaskRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWirelessGatewayTaskRequest, CreateWirelessGatewayTaskResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWirelessGatewayTaskDefinitionResult> createWirelessGatewayTaskDefinitionAsync(
            CreateWirelessGatewayTaskDefinitionRequest request) {

        return createWirelessGatewayTaskDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWirelessGatewayTaskDefinitionResult> createWirelessGatewayTaskDefinitionAsync(
            CreateWirelessGatewayTaskDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWirelessGatewayTaskDefinitionRequest, CreateWirelessGatewayTaskDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDestinationResult> deleteDestinationAsync(DeleteDestinationRequest request) {

        return deleteDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDestinationResult> deleteDestinationAsync(DeleteDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDestinationRequest, DeleteDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDeviceProfileResult> deleteDeviceProfileAsync(DeleteDeviceProfileRequest request) {

        return deleteDeviceProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDeviceProfileResult> deleteDeviceProfileAsync(DeleteDeviceProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDeviceProfileRequest, DeleteDeviceProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceProfileResult> deleteServiceProfileAsync(DeleteServiceProfileRequest request) {

        return deleteServiceProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceProfileResult> deleteServiceProfileAsync(DeleteServiceProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteServiceProfileRequest, DeleteServiceProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWirelessDeviceResult> deleteWirelessDeviceAsync(DeleteWirelessDeviceRequest request) {

        return deleteWirelessDeviceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWirelessDeviceResult> deleteWirelessDeviceAsync(DeleteWirelessDeviceRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWirelessDeviceRequest, DeleteWirelessDeviceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWirelessGatewayResult> deleteWirelessGatewayAsync(DeleteWirelessGatewayRequest request) {

        return deleteWirelessGatewayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWirelessGatewayResult> deleteWirelessGatewayAsync(DeleteWirelessGatewayRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWirelessGatewayRequest, DeleteWirelessGatewayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWirelessGatewayTaskResult> deleteWirelessGatewayTaskAsync(DeleteWirelessGatewayTaskRequest request) {

        return deleteWirelessGatewayTaskAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWirelessGatewayTaskResult> deleteWirelessGatewayTaskAsync(DeleteWirelessGatewayTaskRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWirelessGatewayTaskRequest, DeleteWirelessGatewayTaskResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWirelessGatewayTaskDefinitionResult> deleteWirelessGatewayTaskDefinitionAsync(
            DeleteWirelessGatewayTaskDefinitionRequest request) {

        return deleteWirelessGatewayTaskDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWirelessGatewayTaskDefinitionResult> deleteWirelessGatewayTaskDefinitionAsync(
            DeleteWirelessGatewayTaskDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWirelessGatewayTaskDefinitionRequest, DeleteWirelessGatewayTaskDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateAwsAccountFromPartnerAccountResult> disassociateAwsAccountFromPartnerAccountAsync(
            DisassociateAwsAccountFromPartnerAccountRequest request) {

        return disassociateAwsAccountFromPartnerAccountAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateAwsAccountFromPartnerAccountResult> disassociateAwsAccountFromPartnerAccountAsync(
            DisassociateAwsAccountFromPartnerAccountRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateAwsAccountFromPartnerAccountRequest, DisassociateAwsAccountFromPartnerAccountResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateWirelessDeviceFromThingResult> disassociateWirelessDeviceFromThingAsync(
            DisassociateWirelessDeviceFromThingRequest request) {

        return disassociateWirelessDeviceFromThingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateWirelessDeviceFromThingResult> disassociateWirelessDeviceFromThingAsync(
            DisassociateWirelessDeviceFromThingRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateWirelessDeviceFromThingRequest, DisassociateWirelessDeviceFromThingResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateWirelessGatewayFromCertificateResult> disassociateWirelessGatewayFromCertificateAsync(
            DisassociateWirelessGatewayFromCertificateRequest request) {

        return disassociateWirelessGatewayFromCertificateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateWirelessGatewayFromCertificateResult> disassociateWirelessGatewayFromCertificateAsync(
            DisassociateWirelessGatewayFromCertificateRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateWirelessGatewayFromCertificateRequest, DisassociateWirelessGatewayFromCertificateResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateWirelessGatewayFromThingResult> disassociateWirelessGatewayFromThingAsync(
            DisassociateWirelessGatewayFromThingRequest request) {

        return disassociateWirelessGatewayFromThingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateWirelessGatewayFromThingResult> disassociateWirelessGatewayFromThingAsync(
            DisassociateWirelessGatewayFromThingRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateWirelessGatewayFromThingRequest, DisassociateWirelessGatewayFromThingResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDestinationResult> getDestinationAsync(GetDestinationRequest request) {

        return getDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDestinationResult> getDestinationAsync(GetDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDestinationRequest, GetDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDeviceProfileResult> getDeviceProfileAsync(GetDeviceProfileRequest request) {

        return getDeviceProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDeviceProfileResult> getDeviceProfileAsync(GetDeviceProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDeviceProfileRequest, GetDeviceProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPartnerAccountResult> getPartnerAccountAsync(GetPartnerAccountRequest request) {

        return getPartnerAccountAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPartnerAccountResult> getPartnerAccountAsync(GetPartnerAccountRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPartnerAccountRequest, GetPartnerAccountResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServiceEndpointResult> getServiceEndpointAsync(GetServiceEndpointRequest request) {

        return getServiceEndpointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServiceEndpointResult> getServiceEndpointAsync(GetServiceEndpointRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServiceEndpointRequest, GetServiceEndpointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServiceProfileResult> getServiceProfileAsync(GetServiceProfileRequest request) {

        return getServiceProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServiceProfileResult> getServiceProfileAsync(GetServiceProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServiceProfileRequest, GetServiceProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWirelessDeviceResult> getWirelessDeviceAsync(GetWirelessDeviceRequest request) {

        return getWirelessDeviceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWirelessDeviceResult> getWirelessDeviceAsync(GetWirelessDeviceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWirelessDeviceRequest, GetWirelessDeviceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWirelessDeviceStatisticsResult> getWirelessDeviceStatisticsAsync(GetWirelessDeviceStatisticsRequest request) {

        return getWirelessDeviceStatisticsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWirelessDeviceStatisticsResult> getWirelessDeviceStatisticsAsync(GetWirelessDeviceStatisticsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWirelessDeviceStatisticsRequest, GetWirelessDeviceStatisticsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayResult> getWirelessGatewayAsync(GetWirelessGatewayRequest request) {

        return getWirelessGatewayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayResult> getWirelessGatewayAsync(GetWirelessGatewayRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWirelessGatewayRequest, GetWirelessGatewayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayCertificateResult> getWirelessGatewayCertificateAsync(GetWirelessGatewayCertificateRequest request) {

        return getWirelessGatewayCertificateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayCertificateResult> getWirelessGatewayCertificateAsync(GetWirelessGatewayCertificateRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWirelessGatewayCertificateRequest, GetWirelessGatewayCertificateResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayFirmwareInformationResult> getWirelessGatewayFirmwareInformationAsync(
            GetWirelessGatewayFirmwareInformationRequest request) {

        return getWirelessGatewayFirmwareInformationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayFirmwareInformationResult> getWirelessGatewayFirmwareInformationAsync(
            GetWirelessGatewayFirmwareInformationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWirelessGatewayFirmwareInformationRequest, GetWirelessGatewayFirmwareInformationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayStatisticsResult> getWirelessGatewayStatisticsAsync(GetWirelessGatewayStatisticsRequest request) {

        return getWirelessGatewayStatisticsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayStatisticsResult> getWirelessGatewayStatisticsAsync(GetWirelessGatewayStatisticsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWirelessGatewayStatisticsRequest, GetWirelessGatewayStatisticsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayTaskResult> getWirelessGatewayTaskAsync(GetWirelessGatewayTaskRequest request) {

        return getWirelessGatewayTaskAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayTaskResult> getWirelessGatewayTaskAsync(GetWirelessGatewayTaskRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWirelessGatewayTaskRequest, GetWirelessGatewayTaskResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayTaskDefinitionResult> getWirelessGatewayTaskDefinitionAsync(
            GetWirelessGatewayTaskDefinitionRequest request) {

        return getWirelessGatewayTaskDefinitionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWirelessGatewayTaskDefinitionResult> getWirelessGatewayTaskDefinitionAsync(
            GetWirelessGatewayTaskDefinitionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWirelessGatewayTaskDefinitionRequest, GetWirelessGatewayTaskDefinitionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDestinationsResult> listDestinationsAsync(ListDestinationsRequest request) {

        return listDestinationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDestinationsResult> listDestinationsAsync(ListDestinationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDestinationsRequest, ListDestinationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDeviceProfilesResult> listDeviceProfilesAsync(ListDeviceProfilesRequest request) {

        return listDeviceProfilesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDeviceProfilesResult> listDeviceProfilesAsync(ListDeviceProfilesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDeviceProfilesRequest, ListDeviceProfilesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPartnerAccountsResult> listPartnerAccountsAsync(ListPartnerAccountsRequest request) {

        return listPartnerAccountsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPartnerAccountsResult> listPartnerAccountsAsync(ListPartnerAccountsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPartnerAccountsRequest, ListPartnerAccountsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListServiceProfilesResult> listServiceProfilesAsync(ListServiceProfilesRequest request) {

        return listServiceProfilesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListServiceProfilesResult> listServiceProfilesAsync(ListServiceProfilesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListServiceProfilesRequest, ListServiceProfilesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListWirelessDevicesResult> listWirelessDevicesAsync(ListWirelessDevicesRequest request) {

        return listWirelessDevicesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListWirelessDevicesResult> listWirelessDevicesAsync(ListWirelessDevicesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListWirelessDevicesRequest, ListWirelessDevicesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListWirelessGatewayTaskDefinitionsResult> listWirelessGatewayTaskDefinitionsAsync(
            ListWirelessGatewayTaskDefinitionsRequest request) {

        return listWirelessGatewayTaskDefinitionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListWirelessGatewayTaskDefinitionsResult> listWirelessGatewayTaskDefinitionsAsync(
            ListWirelessGatewayTaskDefinitionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListWirelessGatewayTaskDefinitionsRequest, ListWirelessGatewayTaskDefinitionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListWirelessGatewaysResult> listWirelessGatewaysAsync(ListWirelessGatewaysRequest request) {

        return listWirelessGatewaysAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListWirelessGatewaysResult> listWirelessGatewaysAsync(ListWirelessGatewaysRequest request,
            com.amazonaws.handlers.AsyncHandler<ListWirelessGatewaysRequest, ListWirelessGatewaysResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SendDataToWirelessDeviceResult> sendDataToWirelessDeviceAsync(SendDataToWirelessDeviceRequest request) {

        return sendDataToWirelessDeviceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SendDataToWirelessDeviceResult> sendDataToWirelessDeviceAsync(SendDataToWirelessDeviceRequest request,
            com.amazonaws.handlers.AsyncHandler<SendDataToWirelessDeviceRequest, SendDataToWirelessDeviceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TestWirelessDeviceResult> testWirelessDeviceAsync(TestWirelessDeviceRequest request) {

        return testWirelessDeviceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TestWirelessDeviceResult> testWirelessDeviceAsync(TestWirelessDeviceRequest request,
            com.amazonaws.handlers.AsyncHandler<TestWirelessDeviceRequest, TestWirelessDeviceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDestinationResult> updateDestinationAsync(UpdateDestinationRequest request) {

        return updateDestinationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDestinationResult> updateDestinationAsync(UpdateDestinationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDestinationRequest, UpdateDestinationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePartnerAccountResult> updatePartnerAccountAsync(UpdatePartnerAccountRequest request) {

        return updatePartnerAccountAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePartnerAccountResult> updatePartnerAccountAsync(UpdatePartnerAccountRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePartnerAccountRequest, UpdatePartnerAccountResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateWirelessDeviceResult> updateWirelessDeviceAsync(UpdateWirelessDeviceRequest request) {

        return updateWirelessDeviceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateWirelessDeviceResult> updateWirelessDeviceAsync(UpdateWirelessDeviceRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateWirelessDeviceRequest, UpdateWirelessDeviceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateWirelessGatewayResult> updateWirelessGatewayAsync(UpdateWirelessGatewayRequest request) {

        return updateWirelessGatewayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateWirelessGatewayResult> updateWirelessGatewayAsync(UpdateWirelessGatewayRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateWirelessGatewayRequest, UpdateWirelessGatewayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
