/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.devopsguru;

import javax.annotation.Generated;

import com.amazonaws.services.devopsguru.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonDevOpsGuru}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonDevOpsGuru implements AmazonDevOpsGuru {

    protected AbstractAmazonDevOpsGuru() {
    }

    @Override
    public AddNotificationChannelResult addNotificationChannel(AddNotificationChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountHealthResult describeAccountHealth(DescribeAccountHealthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountOverviewResult describeAccountOverview(DescribeAccountOverviewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAnomalyResult describeAnomaly(DescribeAnomalyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInsightResult describeInsight(DescribeInsightRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeResourceCollectionHealthResult describeResourceCollectionHealth(DescribeResourceCollectionHealthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeServiceIntegrationResult describeServiceIntegration(DescribeServiceIntegrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourceCollectionResult getResourceCollection(GetResourceCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnomaliesForInsightResult listAnomaliesForInsight(ListAnomaliesForInsightRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEventsResult listEvents(ListEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInsightsResult listInsights(ListInsightsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotificationChannelsResult listNotificationChannels(ListNotificationChannelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRecommendationsResult listRecommendations(ListRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutFeedbackResult putFeedback(PutFeedbackRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveNotificationChannelResult removeNotificationChannel(RemoveNotificationChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchInsightsResult searchInsights(SearchInsightsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourceCollectionResult updateResourceCollection(UpdateResourceCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceIntegrationResult updateServiceIntegration(UpdateServiceIntegrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
