/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.securityhub.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AwsCloudFrontDistributionDetailsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AwsCloudFrontDistributionDetailsMarshaller {

    private static final MarshallingInfo<StructuredPojo> CACHEBEHAVIORS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CacheBehaviors").build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTCACHEBEHAVIOR_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultCacheBehavior").build();
    private static final MarshallingInfo<String> DEFAULTROOTOBJECT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultRootObject").build();
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<String> ETAG_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ETag").build();
    private static final MarshallingInfo<String> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").build();
    private static final MarshallingInfo<StructuredPojo> LOGGING_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Logging").build();
    private static final MarshallingInfo<StructuredPojo> ORIGINS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Origins").build();
    private static final MarshallingInfo<StructuredPojo> ORIGINGROUPS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OriginGroups").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Status").build();
    private static final MarshallingInfo<String> WEBACLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("WebAclId").build();

    private static final AwsCloudFrontDistributionDetailsMarshaller instance = new AwsCloudFrontDistributionDetailsMarshaller();

    public static AwsCloudFrontDistributionDetailsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AwsCloudFrontDistributionDetails awsCloudFrontDistributionDetails, ProtocolMarshaller protocolMarshaller) {

        if (awsCloudFrontDistributionDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getCacheBehaviors(), CACHEBEHAVIORS_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getDefaultCacheBehavior(), DEFAULTCACHEBEHAVIOR_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getDefaultRootObject(), DEFAULTROOTOBJECT_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getDomainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getETag(), ETAG_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getLogging(), LOGGING_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getOrigins(), ORIGINS_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getOriginGroups(), ORIGINGROUPS_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(awsCloudFrontDistributionDetails.getWebAclId(), WEBACLID_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
