/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAvailabilityZonesRequestMarshaller
implements Marshaller<Request<DescribeAvailabilityZonesRequest>, DescribeAvailabilityZonesRequest> {
    @Override
    public Request<DescribeAvailabilityZonesRequest> marshall(DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) {
        SdkInternalList describeAvailabilityZonesRequestFiltersList;
        if (describeAvailabilityZonesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAvailabilityZonesRequest> request = new DefaultRequest<DescribeAvailabilityZonesRequest>(describeAvailabilityZonesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeAvailabilityZones");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeAvailabilityZonesRequestZoneNamesList = (SdkInternalList)describeAvailabilityZonesRequest.getZoneNames();
        if (!describeAvailabilityZonesRequestZoneNamesList.isEmpty() || !describeAvailabilityZonesRequestZoneNamesList.isAutoConstruct()) {
            int zoneNamesListIndex = 1;
            for (String describeAvailabilityZonesRequestZoneNamesListValue : describeAvailabilityZonesRequestZoneNamesList) {
                if (describeAvailabilityZonesRequestZoneNamesListValue != null) {
                    request.addParameter("ZoneName." + zoneNamesListIndex, StringUtils.fromString(describeAvailabilityZonesRequestZoneNamesListValue));
                }
                ++zoneNamesListIndex;
            }
        }
        if (!(describeAvailabilityZonesRequestFiltersList = (SdkInternalList)describeAvailabilityZonesRequest.getFilters()).isEmpty() || !describeAvailabilityZonesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeAvailabilityZonesRequestFiltersListValue : describeAvailabilityZonesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeAvailabilityZonesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeAvailabilityZonesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeAvailabilityZonesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

