/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.resiliencehub.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ImportResourcesToDraftAppVersion"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ImportResourcesToDraftAppVersionRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:
     * <code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     */
    private String appArn;
    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the resources that you want to import.
     * </p>
     */
    private java.util.List<String> sourceArns;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:
     * <code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @param appArn
     *        The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     *        :dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
     *        see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
     *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
     */

    public void setAppArn(String appArn) {
        this.appArn = appArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:
     * <code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     *         :dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
     *         Names (ARNs)</a> in the <i>AWS General Reference</i>.
     */

    public String getAppArn() {
        return this.appArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:
     * <code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @param appArn
     *        The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     *        :dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
     *        see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
     *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ImportResourcesToDraftAppVersionRequest withAppArn(String appArn) {
        setAppArn(appArn);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the resources that you want to import.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) for the resources that you want to import.
     */

    public java.util.List<String> getSourceArns() {
        return sourceArns;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the resources that you want to import.
     * </p>
     * 
     * @param sourceArns
     *        The Amazon Resource Names (ARNs) for the resources that you want to import.
     */

    public void setSourceArns(java.util.Collection<String> sourceArns) {
        if (sourceArns == null) {
            this.sourceArns = null;
            return;
        }

        this.sourceArns = new java.util.ArrayList<String>(sourceArns);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the resources that you want to import.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSourceArns(java.util.Collection)} or {@link #withSourceArns(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param sourceArns
     *        The Amazon Resource Names (ARNs) for the resources that you want to import.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ImportResourcesToDraftAppVersionRequest withSourceArns(String... sourceArns) {
        if (this.sourceArns == null) {
            setSourceArns(new java.util.ArrayList<String>(sourceArns.length));
        }
        for (String ele : sourceArns) {
            this.sourceArns.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the resources that you want to import.
     * </p>
     * 
     * @param sourceArns
     *        The Amazon Resource Names (ARNs) for the resources that you want to import.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ImportResourcesToDraftAppVersionRequest withSourceArns(java.util.Collection<String> sourceArns) {
        setSourceArns(sourceArns);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAppArn() != null)
            sb.append("AppArn: ").append(getAppArn()).append(",");
        if (getSourceArns() != null)
            sb.append("SourceArns: ").append(getSourceArns());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ImportResourcesToDraftAppVersionRequest == false)
            return false;
        ImportResourcesToDraftAppVersionRequest other = (ImportResourcesToDraftAppVersionRequest) obj;
        if (other.getAppArn() == null ^ this.getAppArn() == null)
            return false;
        if (other.getAppArn() != null && other.getAppArn().equals(this.getAppArn()) == false)
            return false;
        if (other.getSourceArns() == null ^ this.getSourceArns() == null)
            return false;
        if (other.getSourceArns() != null && other.getSourceArns().equals(this.getSourceArns()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAppArn() == null) ? 0 : getAppArn().hashCode());
        hashCode = prime * hashCode + ((getSourceArns() == null) ? 0 : getSourceArns().hashCode());
        return hashCode;
    }

    @Override
    public ImportResourcesToDraftAppVersionRequest clone() {
        return (ImportResourcesToDraftAppVersionRequest) super.clone();
    }

}
