/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.forecast.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.forecast.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetAccuracyMetricsResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetAccuracyMetricsResultJsonUnmarshaller implements Unmarshaller<GetAccuracyMetricsResult, JsonUnmarshallerContext> {

    public GetAccuracyMetricsResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetAccuracyMetricsResult getAccuracyMetricsResult = new GetAccuracyMetricsResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getAccuracyMetricsResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("PredictorEvaluationResults", targetDepth)) {
                    context.nextToken();
                    getAccuracyMetricsResult.setPredictorEvaluationResults(new ListUnmarshaller<EvaluationResult>(EvaluationResultJsonUnmarshaller
                            .getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("IsAutoPredictor", targetDepth)) {
                    context.nextToken();
                    getAccuracyMetricsResult.setIsAutoPredictor(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("AutoMLOverrideStrategy", targetDepth)) {
                    context.nextToken();
                    getAccuracyMetricsResult.setAutoMLOverrideStrategy(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OptimizationMetric", targetDepth)) {
                    context.nextToken();
                    getAccuracyMetricsResult.setOptimizationMetric(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getAccuracyMetricsResult;
    }

    private static GetAccuracyMetricsResultJsonUnmarshaller instance;

    public static GetAccuracyMetricsResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new GetAccuracyMetricsResultJsonUnmarshaller();
        return instance;
    }
}
