/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotsitewise;

import javax.annotation.Generated;

import com.amazonaws.services.iotsitewise.model.*;
import com.amazonaws.*;
import com.amazonaws.services.iotsitewise.waiters.AWSIoTSiteWiseWaiters;

/**
 * Abstract implementation of {@code AWSIoTSiteWise}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTSiteWise implements AWSIoTSiteWise {

    protected AbstractAWSIoTSiteWise() {
    }

    @Override
    public AssociateAssetsResult associateAssets(AssociateAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateTimeSeriesToAssetPropertyResult associateTimeSeriesToAssetProperty(AssociateTimeSeriesToAssetPropertyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchAssociateProjectAssetsResult batchAssociateProjectAssets(BatchAssociateProjectAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDisassociateProjectAssetsResult batchDisassociateProjectAssets(BatchDisassociateProjectAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchPutAssetPropertyValueResult batchPutAssetPropertyValue(BatchPutAssetPropertyValueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccessPolicyResult createAccessPolicy(CreateAccessPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssetResult createAsset(CreateAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssetModelResult createAssetModel(CreateAssetModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDashboardResult createDashboard(CreateDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGatewayResult createGateway(CreateGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePortalResult createPortal(CreatePortalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccessPolicyResult deleteAccessPolicy(DeleteAccessPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssetResult deleteAsset(DeleteAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssetModelResult deleteAssetModel(DeleteAssetModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDashboardResult deleteDashboard(DeleteDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGatewayResult deleteGateway(DeleteGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePortalResult deletePortal(DeletePortalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTimeSeriesResult deleteTimeSeries(DeleteTimeSeriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccessPolicyResult describeAccessPolicy(DescribeAccessPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAssetResult describeAsset(DescribeAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAssetModelResult describeAssetModel(DescribeAssetModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAssetPropertyResult describeAssetProperty(DescribeAssetPropertyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDashboardResult describeDashboard(DescribeDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDefaultEncryptionConfigurationResult describeDefaultEncryptionConfiguration(DescribeDefaultEncryptionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGatewayResult describeGateway(DescribeGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGatewayCapabilityConfigurationResult describeGatewayCapabilityConfiguration(DescribeGatewayCapabilityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLoggingOptionsResult describeLoggingOptions(DescribeLoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePortalResult describePortal(DescribePortalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProjectResult describeProject(DescribeProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeStorageConfigurationResult describeStorageConfiguration(DescribeStorageConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTimeSeriesResult describeTimeSeries(DescribeTimeSeriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateAssetsResult disassociateAssets(DisassociateAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateTimeSeriesFromAssetPropertyResult disassociateTimeSeriesFromAssetProperty(DisassociateTimeSeriesFromAssetPropertyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssetPropertyAggregatesResult getAssetPropertyAggregates(GetAssetPropertyAggregatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssetPropertyValueResult getAssetPropertyValue(GetAssetPropertyValueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssetPropertyValueHistoryResult getAssetPropertyValueHistory(GetAssetPropertyValueHistoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInterpolatedAssetPropertyValuesResult getInterpolatedAssetPropertyValues(GetInterpolatedAssetPropertyValuesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccessPoliciesResult listAccessPolicies(ListAccessPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssetModelsResult listAssetModels(ListAssetModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssetRelationshipsResult listAssetRelationships(ListAssetRelationshipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssetsResult listAssets(ListAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssociatedAssetsResult listAssociatedAssets(ListAssociatedAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDashboardsResult listDashboards(ListDashboardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGatewaysResult listGateways(ListGatewaysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPortalsResult listPortals(ListPortalsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProjectAssetsResult listProjectAssets(ListProjectAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTimeSeriesResult listTimeSeries(ListTimeSeriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutDefaultEncryptionConfigurationResult putDefaultEncryptionConfiguration(PutDefaultEncryptionConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutLoggingOptionsResult putLoggingOptions(PutLoggingOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutStorageConfigurationResult putStorageConfiguration(PutStorageConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccessPolicyResult updateAccessPolicy(UpdateAccessPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssetResult updateAsset(UpdateAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssetModelResult updateAssetModel(UpdateAssetModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssetPropertyResult updateAssetProperty(UpdateAssetPropertyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDashboardResult updateDashboard(UpdateDashboardRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGatewayResult updateGateway(UpdateGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGatewayCapabilityConfigurationResult updateGatewayCapabilityConfiguration(UpdateGatewayCapabilityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePortalResult updatePortal(UpdatePortalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AWSIoTSiteWiseWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
