/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.networkmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateVpcAttachment" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateVpcAttachmentResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Describes the updated VPC attachment.
     * </p>
     */
    private VpcAttachment vpcAttachment;

    /**
     * <p>
     * Describes the updated VPC attachment.
     * </p>
     * 
     * @param vpcAttachment
     *        Describes the updated VPC attachment.
     */

    public void setVpcAttachment(VpcAttachment vpcAttachment) {
        this.vpcAttachment = vpcAttachment;
    }

    /**
     * <p>
     * Describes the updated VPC attachment.
     * </p>
     * 
     * @return Describes the updated VPC attachment.
     */

    public VpcAttachment getVpcAttachment() {
        return this.vpcAttachment;
    }

    /**
     * <p>
     * Describes the updated VPC attachment.
     * </p>
     * 
     * @param vpcAttachment
     *        Describes the updated VPC attachment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateVpcAttachmentResult withVpcAttachment(VpcAttachment vpcAttachment) {
        setVpcAttachment(vpcAttachment);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getVpcAttachment() != null)
            sb.append("VpcAttachment: ").append(getVpcAttachment());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateVpcAttachmentResult == false)
            return false;
        UpdateVpcAttachmentResult other = (UpdateVpcAttachmentResult) obj;
        if (other.getVpcAttachment() == null ^ this.getVpcAttachment() == null)
            return false;
        if (other.getVpcAttachment() != null && other.getVpcAttachment().equals(this.getVpcAttachment()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getVpcAttachment() == null) ? 0 : getVpcAttachment().hashCode());
        return hashCode;
    }

    @Override
    public UpdateVpcAttachmentResult clone() {
        try {
            return (UpdateVpcAttachmentResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
