/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.location;

import javax.annotation.Generated;

import com.amazonaws.services.location.model.*;

/**
 * Abstract implementation of {@code AmazonLocationAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonLocationAsync extends AbstractAmazonLocation implements AmazonLocationAsync {

    protected AbstractAmazonLocationAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateTrackerConsumerResult> associateTrackerConsumerAsync(AssociateTrackerConsumerRequest request) {

        return associateTrackerConsumerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateTrackerConsumerResult> associateTrackerConsumerAsync(AssociateTrackerConsumerRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateTrackerConsumerRequest, AssociateTrackerConsumerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchDeleteDevicePositionHistoryResult> batchDeleteDevicePositionHistoryAsync(
            BatchDeleteDevicePositionHistoryRequest request) {

        return batchDeleteDevicePositionHistoryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchDeleteDevicePositionHistoryResult> batchDeleteDevicePositionHistoryAsync(
            BatchDeleteDevicePositionHistoryRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchDeleteDevicePositionHistoryRequest, BatchDeleteDevicePositionHistoryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchDeleteGeofenceResult> batchDeleteGeofenceAsync(BatchDeleteGeofenceRequest request) {

        return batchDeleteGeofenceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchDeleteGeofenceResult> batchDeleteGeofenceAsync(BatchDeleteGeofenceRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchDeleteGeofenceRequest, BatchDeleteGeofenceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchEvaluateGeofencesResult> batchEvaluateGeofencesAsync(BatchEvaluateGeofencesRequest request) {

        return batchEvaluateGeofencesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchEvaluateGeofencesResult> batchEvaluateGeofencesAsync(BatchEvaluateGeofencesRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchEvaluateGeofencesRequest, BatchEvaluateGeofencesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchGetDevicePositionResult> batchGetDevicePositionAsync(BatchGetDevicePositionRequest request) {

        return batchGetDevicePositionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchGetDevicePositionResult> batchGetDevicePositionAsync(BatchGetDevicePositionRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchGetDevicePositionRequest, BatchGetDevicePositionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchPutGeofenceResult> batchPutGeofenceAsync(BatchPutGeofenceRequest request) {

        return batchPutGeofenceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchPutGeofenceResult> batchPutGeofenceAsync(BatchPutGeofenceRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchPutGeofenceRequest, BatchPutGeofenceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchUpdateDevicePositionResult> batchUpdateDevicePositionAsync(BatchUpdateDevicePositionRequest request) {

        return batchUpdateDevicePositionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchUpdateDevicePositionResult> batchUpdateDevicePositionAsync(BatchUpdateDevicePositionRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchUpdateDevicePositionRequest, BatchUpdateDevicePositionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CalculateRouteResult> calculateRouteAsync(CalculateRouteRequest request) {

        return calculateRouteAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CalculateRouteResult> calculateRouteAsync(CalculateRouteRequest request,
            com.amazonaws.handlers.AsyncHandler<CalculateRouteRequest, CalculateRouteResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateGeofenceCollectionResult> createGeofenceCollectionAsync(CreateGeofenceCollectionRequest request) {

        return createGeofenceCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateGeofenceCollectionResult> createGeofenceCollectionAsync(CreateGeofenceCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateGeofenceCollectionRequest, CreateGeofenceCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateMapResult> createMapAsync(CreateMapRequest request) {

        return createMapAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateMapResult> createMapAsync(CreateMapRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateMapRequest, CreateMapResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreatePlaceIndexResult> createPlaceIndexAsync(CreatePlaceIndexRequest request) {

        return createPlaceIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreatePlaceIndexResult> createPlaceIndexAsync(CreatePlaceIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<CreatePlaceIndexRequest, CreatePlaceIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRouteCalculatorResult> createRouteCalculatorAsync(CreateRouteCalculatorRequest request) {

        return createRouteCalculatorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRouteCalculatorResult> createRouteCalculatorAsync(CreateRouteCalculatorRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRouteCalculatorRequest, CreateRouteCalculatorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTrackerResult> createTrackerAsync(CreateTrackerRequest request) {

        return createTrackerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTrackerResult> createTrackerAsync(CreateTrackerRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTrackerRequest, CreateTrackerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteGeofenceCollectionResult> deleteGeofenceCollectionAsync(DeleteGeofenceCollectionRequest request) {

        return deleteGeofenceCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteGeofenceCollectionResult> deleteGeofenceCollectionAsync(DeleteGeofenceCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteGeofenceCollectionRequest, DeleteGeofenceCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteMapResult> deleteMapAsync(DeleteMapRequest request) {

        return deleteMapAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteMapResult> deleteMapAsync(DeleteMapRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteMapRequest, DeleteMapResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeletePlaceIndexResult> deletePlaceIndexAsync(DeletePlaceIndexRequest request) {

        return deletePlaceIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeletePlaceIndexResult> deletePlaceIndexAsync(DeletePlaceIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<DeletePlaceIndexRequest, DeletePlaceIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRouteCalculatorResult> deleteRouteCalculatorAsync(DeleteRouteCalculatorRequest request) {

        return deleteRouteCalculatorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRouteCalculatorResult> deleteRouteCalculatorAsync(DeleteRouteCalculatorRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRouteCalculatorRequest, DeleteRouteCalculatorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTrackerResult> deleteTrackerAsync(DeleteTrackerRequest request) {

        return deleteTrackerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTrackerResult> deleteTrackerAsync(DeleteTrackerRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTrackerRequest, DeleteTrackerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeGeofenceCollectionResult> describeGeofenceCollectionAsync(DescribeGeofenceCollectionRequest request) {

        return describeGeofenceCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeGeofenceCollectionResult> describeGeofenceCollectionAsync(DescribeGeofenceCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeGeofenceCollectionRequest, DescribeGeofenceCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeMapResult> describeMapAsync(DescribeMapRequest request) {

        return describeMapAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeMapResult> describeMapAsync(DescribeMapRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeMapRequest, DescribeMapResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribePlaceIndexResult> describePlaceIndexAsync(DescribePlaceIndexRequest request) {

        return describePlaceIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribePlaceIndexResult> describePlaceIndexAsync(DescribePlaceIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribePlaceIndexRequest, DescribePlaceIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRouteCalculatorResult> describeRouteCalculatorAsync(DescribeRouteCalculatorRequest request) {

        return describeRouteCalculatorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRouteCalculatorResult> describeRouteCalculatorAsync(DescribeRouteCalculatorRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRouteCalculatorRequest, DescribeRouteCalculatorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeTrackerResult> describeTrackerAsync(DescribeTrackerRequest request) {

        return describeTrackerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeTrackerResult> describeTrackerAsync(DescribeTrackerRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeTrackerRequest, DescribeTrackerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateTrackerConsumerResult> disassociateTrackerConsumerAsync(DisassociateTrackerConsumerRequest request) {

        return disassociateTrackerConsumerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateTrackerConsumerResult> disassociateTrackerConsumerAsync(DisassociateTrackerConsumerRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateTrackerConsumerRequest, DisassociateTrackerConsumerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDevicePositionResult> getDevicePositionAsync(GetDevicePositionRequest request) {

        return getDevicePositionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDevicePositionResult> getDevicePositionAsync(GetDevicePositionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDevicePositionRequest, GetDevicePositionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDevicePositionHistoryResult> getDevicePositionHistoryAsync(GetDevicePositionHistoryRequest request) {

        return getDevicePositionHistoryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDevicePositionHistoryResult> getDevicePositionHistoryAsync(GetDevicePositionHistoryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDevicePositionHistoryRequest, GetDevicePositionHistoryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGeofenceResult> getGeofenceAsync(GetGeofenceRequest request) {

        return getGeofenceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGeofenceResult> getGeofenceAsync(GetGeofenceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGeofenceRequest, GetGeofenceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMapGlyphsResult> getMapGlyphsAsync(GetMapGlyphsRequest request) {

        return getMapGlyphsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMapGlyphsResult> getMapGlyphsAsync(GetMapGlyphsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMapGlyphsRequest, GetMapGlyphsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMapSpritesResult> getMapSpritesAsync(GetMapSpritesRequest request) {

        return getMapSpritesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMapSpritesResult> getMapSpritesAsync(GetMapSpritesRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMapSpritesRequest, GetMapSpritesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMapStyleDescriptorResult> getMapStyleDescriptorAsync(GetMapStyleDescriptorRequest request) {

        return getMapStyleDescriptorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMapStyleDescriptorResult> getMapStyleDescriptorAsync(GetMapStyleDescriptorRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMapStyleDescriptorRequest, GetMapStyleDescriptorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMapTileResult> getMapTileAsync(GetMapTileRequest request) {

        return getMapTileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMapTileResult> getMapTileAsync(GetMapTileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMapTileRequest, GetMapTileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDevicePositionsResult> listDevicePositionsAsync(ListDevicePositionsRequest request) {

        return listDevicePositionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDevicePositionsResult> listDevicePositionsAsync(ListDevicePositionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDevicePositionsRequest, ListDevicePositionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGeofenceCollectionsResult> listGeofenceCollectionsAsync(ListGeofenceCollectionsRequest request) {

        return listGeofenceCollectionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGeofenceCollectionsResult> listGeofenceCollectionsAsync(ListGeofenceCollectionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGeofenceCollectionsRequest, ListGeofenceCollectionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGeofencesResult> listGeofencesAsync(ListGeofencesRequest request) {

        return listGeofencesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGeofencesResult> listGeofencesAsync(ListGeofencesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGeofencesRequest, ListGeofencesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMapsResult> listMapsAsync(ListMapsRequest request) {

        return listMapsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMapsResult> listMapsAsync(ListMapsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMapsRequest, ListMapsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPlaceIndexesResult> listPlaceIndexesAsync(ListPlaceIndexesRequest request) {

        return listPlaceIndexesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPlaceIndexesResult> listPlaceIndexesAsync(ListPlaceIndexesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPlaceIndexesRequest, ListPlaceIndexesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRouteCalculatorsResult> listRouteCalculatorsAsync(ListRouteCalculatorsRequest request) {

        return listRouteCalculatorsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRouteCalculatorsResult> listRouteCalculatorsAsync(ListRouteCalculatorsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRouteCalculatorsRequest, ListRouteCalculatorsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTrackerConsumersResult> listTrackerConsumersAsync(ListTrackerConsumersRequest request) {

        return listTrackerConsumersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTrackerConsumersResult> listTrackerConsumersAsync(ListTrackerConsumersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTrackerConsumersRequest, ListTrackerConsumersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTrackersResult> listTrackersAsync(ListTrackersRequest request) {

        return listTrackersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTrackersResult> listTrackersAsync(ListTrackersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTrackersRequest, ListTrackersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutGeofenceResult> putGeofenceAsync(PutGeofenceRequest request) {

        return putGeofenceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutGeofenceResult> putGeofenceAsync(PutGeofenceRequest request,
            com.amazonaws.handlers.AsyncHandler<PutGeofenceRequest, PutGeofenceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchPlaceIndexForPositionResult> searchPlaceIndexForPositionAsync(SearchPlaceIndexForPositionRequest request) {

        return searchPlaceIndexForPositionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchPlaceIndexForPositionResult> searchPlaceIndexForPositionAsync(SearchPlaceIndexForPositionRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchPlaceIndexForPositionRequest, SearchPlaceIndexForPositionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchPlaceIndexForSuggestionsResult> searchPlaceIndexForSuggestionsAsync(SearchPlaceIndexForSuggestionsRequest request) {

        return searchPlaceIndexForSuggestionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchPlaceIndexForSuggestionsResult> searchPlaceIndexForSuggestionsAsync(SearchPlaceIndexForSuggestionsRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchPlaceIndexForSuggestionsRequest, SearchPlaceIndexForSuggestionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchPlaceIndexForTextResult> searchPlaceIndexForTextAsync(SearchPlaceIndexForTextRequest request) {

        return searchPlaceIndexForTextAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchPlaceIndexForTextResult> searchPlaceIndexForTextAsync(SearchPlaceIndexForTextRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchPlaceIndexForTextRequest, SearchPlaceIndexForTextResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGeofenceCollectionResult> updateGeofenceCollectionAsync(UpdateGeofenceCollectionRequest request) {

        return updateGeofenceCollectionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGeofenceCollectionResult> updateGeofenceCollectionAsync(UpdateGeofenceCollectionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGeofenceCollectionRequest, UpdateGeofenceCollectionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateMapResult> updateMapAsync(UpdateMapRequest request) {

        return updateMapAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateMapResult> updateMapAsync(UpdateMapRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateMapRequest, UpdateMapResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePlaceIndexResult> updatePlaceIndexAsync(UpdatePlaceIndexRequest request) {

        return updatePlaceIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePlaceIndexResult> updatePlaceIndexAsync(UpdatePlaceIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePlaceIndexRequest, UpdatePlaceIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateRouteCalculatorResult> updateRouteCalculatorAsync(UpdateRouteCalculatorRequest request) {

        return updateRouteCalculatorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateRouteCalculatorResult> updateRouteCalculatorAsync(UpdateRouteCalculatorRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateRouteCalculatorRequest, UpdateRouteCalculatorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTrackerResult> updateTrackerAsync(UpdateTrackerRequest request) {

        return updateTrackerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTrackerResult> updateTrackerAsync(UpdateTrackerRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTrackerRequest, UpdateTrackerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
