/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotanalytics.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A collection of data from an MQTT topic. Channels archive the raw, unprocessed messages before publishing the data to
 * a pipeline.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/Channel" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Channel implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the channel.
     * </p>
     */
    private String name;
    /**
     * <p>
     * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't
     * change this storage option after the channel is created.
     * </p>
     */
    private ChannelStorage storage;
    /**
     * <p>
     * The ARN of the channel.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The status of the channel.
     * </p>
     */
    private String status;
    /**
     * <p>
     * How long, in days, message data is kept for the channel.
     * </p>
     */
    private RetentionPeriod retentionPeriod;
    /**
     * <p>
     * When the channel was created.
     * </p>
     */
    private java.util.Date creationTime;
    /**
     * <p>
     * When the channel was last updated.
     * </p>
     */
    private java.util.Date lastUpdateTime;
    /**
     * <p>
     * The last time when a new message arrived in the channel.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the
     * <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     */
    private java.util.Date lastMessageArrivalTime;

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @param name
     *        The name of the channel.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @param name
     *        The name of the channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Channel withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't
     * change this storage option after the channel is created.
     * </p>
     * 
     * @param storage
     *        Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     *        <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>.
     *        You can't change this storage option after the channel is created.
     */

    public void setStorage(ChannelStorage storage) {
        this.storage = storage;
    }

    /**
     * <p>
     * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't
     * change this storage option after the channel is created.
     * </p>
     * 
     * @return Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     *         <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>.
     *         You can't change this storage option after the channel is created.
     */

    public ChannelStorage getStorage() {
        return this.storage;
    }

    /**
     * <p>
     * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't
     * change this storage option after the channel is created.
     * </p>
     * 
     * @param storage
     *        Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     *        <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>.
     *        You can't change this storage option after the channel is created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Channel withStorage(ChannelStorage storage) {
        setStorage(storage);
        return this;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @param arn
     *        The ARN of the channel.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @param arn
     *        The ARN of the channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Channel withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * 
     * @param status
     *        The status of the channel.
     * @see ChannelStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * 
     * @return The status of the channel.
     * @see ChannelStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * 
     * @param status
     *        The status of the channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ChannelStatus
     */

    public Channel withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * 
     * @param status
     *        The status of the channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ChannelStatus
     */

    public Channel withStatus(ChannelStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the channel.
     * </p>
     * 
     * @param retentionPeriod
     *        How long, in days, message data is kept for the channel.
     */

    public void setRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the channel.
     * </p>
     * 
     * @return How long, in days, message data is kept for the channel.
     */

    public RetentionPeriod getRetentionPeriod() {
        return this.retentionPeriod;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the channel.
     * </p>
     * 
     * @param retentionPeriod
     *        How long, in days, message data is kept for the channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Channel withRetentionPeriod(RetentionPeriod retentionPeriod) {
        setRetentionPeriod(retentionPeriod);
        return this;
    }

    /**
     * <p>
     * When the channel was created.
     * </p>
     * 
     * @param creationTime
     *        When the channel was created.
     */

    public void setCreationTime(java.util.Date creationTime) {
        this.creationTime = creationTime;
    }

    /**
     * <p>
     * When the channel was created.
     * </p>
     * 
     * @return When the channel was created.
     */

    public java.util.Date getCreationTime() {
        return this.creationTime;
    }

    /**
     * <p>
     * When the channel was created.
     * </p>
     * 
     * @param creationTime
     *        When the channel was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Channel withCreationTime(java.util.Date creationTime) {
        setCreationTime(creationTime);
        return this;
    }

    /**
     * <p>
     * When the channel was last updated.
     * </p>
     * 
     * @param lastUpdateTime
     *        When the channel was last updated.
     */

    public void setLastUpdateTime(java.util.Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    /**
     * <p>
     * When the channel was last updated.
     * </p>
     * 
     * @return When the channel was last updated.
     */

    public java.util.Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    /**
     * <p>
     * When the channel was last updated.
     * </p>
     * 
     * @param lastUpdateTime
     *        When the channel was last updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Channel withLastUpdateTime(java.util.Date lastUpdateTime) {
        setLastUpdateTime(lastUpdateTime);
        return this;
    }

    /**
     * <p>
     * The last time when a new message arrived in the channel.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the
     * <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     * 
     * @param lastMessageArrivalTime
     *        The last time when a new message arrived in the channel.</p>
     *        <p>
     *        IoT Analytics updates this value at most once per minute for one channel. Hence, the
     *        <code>lastMessageArrivalTime</code> value is an approximation.
     *        </p>
     *        <p>
     *        This feature only applies to messages that arrived in the data store after October 23, 2020.
     */

    public void setLastMessageArrivalTime(java.util.Date lastMessageArrivalTime) {
        this.lastMessageArrivalTime = lastMessageArrivalTime;
    }

    /**
     * <p>
     * The last time when a new message arrived in the channel.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the
     * <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     * 
     * @return The last time when a new message arrived in the channel.</p>
     *         <p>
     *         IoT Analytics updates this value at most once per minute for one channel. Hence, the
     *         <code>lastMessageArrivalTime</code> value is an approximation.
     *         </p>
     *         <p>
     *         This feature only applies to messages that arrived in the data store after October 23, 2020.
     */

    public java.util.Date getLastMessageArrivalTime() {
        return this.lastMessageArrivalTime;
    }

    /**
     * <p>
     * The last time when a new message arrived in the channel.
     * </p>
     * <p>
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the
     * <code>lastMessageArrivalTime</code> value is an approximation.
     * </p>
     * <p>
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     * </p>
     * 
     * @param lastMessageArrivalTime
     *        The last time when a new message arrived in the channel.</p>
     *        <p>
     *        IoT Analytics updates this value at most once per minute for one channel. Hence, the
     *        <code>lastMessageArrivalTime</code> value is an approximation.
     *        </p>
     *        <p>
     *        This feature only applies to messages that arrived in the data store after October 23, 2020.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Channel withLastMessageArrivalTime(java.util.Date lastMessageArrivalTime) {
        setLastMessageArrivalTime(lastMessageArrivalTime);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getStorage() != null)
            sb.append("Storage: ").append(getStorage()).append(",");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getRetentionPeriod() != null)
            sb.append("RetentionPeriod: ").append(getRetentionPeriod()).append(",");
        if (getCreationTime() != null)
            sb.append("CreationTime: ").append(getCreationTime()).append(",");
        if (getLastUpdateTime() != null)
            sb.append("LastUpdateTime: ").append(getLastUpdateTime()).append(",");
        if (getLastMessageArrivalTime() != null)
            sb.append("LastMessageArrivalTime: ").append(getLastMessageArrivalTime());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Channel == false)
            return false;
        Channel other = (Channel) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getStorage() == null ^ this.getStorage() == null)
            return false;
        if (other.getStorage() != null && other.getStorage().equals(this.getStorage()) == false)
            return false;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getRetentionPeriod() == null ^ this.getRetentionPeriod() == null)
            return false;
        if (other.getRetentionPeriod() != null && other.getRetentionPeriod().equals(this.getRetentionPeriod()) == false)
            return false;
        if (other.getCreationTime() == null ^ this.getCreationTime() == null)
            return false;
        if (other.getCreationTime() != null && other.getCreationTime().equals(this.getCreationTime()) == false)
            return false;
        if (other.getLastUpdateTime() == null ^ this.getLastUpdateTime() == null)
            return false;
        if (other.getLastUpdateTime() != null && other.getLastUpdateTime().equals(this.getLastUpdateTime()) == false)
            return false;
        if (other.getLastMessageArrivalTime() == null ^ this.getLastMessageArrivalTime() == null)
            return false;
        if (other.getLastMessageArrivalTime() != null && other.getLastMessageArrivalTime().equals(this.getLastMessageArrivalTime()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getStorage() == null) ? 0 : getStorage().hashCode());
        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getRetentionPeriod() == null) ? 0 : getRetentionPeriod().hashCode());
        hashCode = prime * hashCode + ((getCreationTime() == null) ? 0 : getCreationTime().hashCode());
        hashCode = prime * hashCode + ((getLastUpdateTime() == null) ? 0 : getLastUpdateTime().hashCode());
        hashCode = prime * hashCode + ((getLastMessageArrivalTime() == null) ? 0 : getLastMessageArrivalTime().hashCode());
        return hashCode;
    }

    @Override
    public Channel clone() {
        try {
            return (Channel) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.iotanalytics.model.transform.ChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
