/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Use Amazon Web Services Cloud Control API to create, read, update, delete, and list (CRUD-L) your cloud resources
 * that belong to a wide range of services--both Amazon Web Services and third-party. With the Cloud Control API
 * standardized set of application programming interfaces (APIs), you can perform CRUD-L operations on any supported
 * resources in your Amazon Web Services account. Using Cloud Control API, you won't have to generate code or scripts
 * specific to each individual service responsible for those resources.
 * </p>
 * <p>
 * For more information about Amazon Web Services Cloud Control API, see the <a
 * href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/what-is-cloudcontrolapi.html">Amazon Web Services
 * Cloud Control API User Guide</a>.
 * </p>
 */
package com.amazonaws.services.cloudcontrolapi;

