/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotdata.model;

import java.io.Serializable;
import javax.annotation.Generated;

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListRetainedMessagesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A summary list the account's retained messages. The information returned doesn't include the message payloads of
     * the retained messages.
     * </p>
     */
    private java.util.List<RetainedMessageSummary> retainedTopics;
    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A summary list the account's retained messages. The information returned doesn't include the message payloads of
     * the retained messages.
     * </p>
     * 
     * @return A summary list the account's retained messages. The information returned doesn't include the message
     *         payloads of the retained messages.
     */

    public java.util.List<RetainedMessageSummary> getRetainedTopics() {
        return retainedTopics;
    }

    /**
     * <p>
     * A summary list the account's retained messages. The information returned doesn't include the message payloads of
     * the retained messages.
     * </p>
     * 
     * @param retainedTopics
     *        A summary list the account's retained messages. The information returned doesn't include the message
     *        payloads of the retained messages.
     */

    public void setRetainedTopics(java.util.Collection<RetainedMessageSummary> retainedTopics) {
        if (retainedTopics == null) {
            this.retainedTopics = null;
            return;
        }

        this.retainedTopics = new java.util.ArrayList<RetainedMessageSummary>(retainedTopics);
    }

    /**
     * <p>
     * A summary list the account's retained messages. The information returned doesn't include the message payloads of
     * the retained messages.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRetainedTopics(java.util.Collection)} or {@link #withRetainedTopics(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param retainedTopics
     *        A summary list the account's retained messages. The information returned doesn't include the message
     *        payloads of the retained messages.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRetainedMessagesResult withRetainedTopics(RetainedMessageSummary... retainedTopics) {
        if (this.retainedTopics == null) {
            setRetainedTopics(new java.util.ArrayList<RetainedMessageSummary>(retainedTopics.length));
        }
        for (RetainedMessageSummary ele : retainedTopics) {
            this.retainedTopics.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A summary list the account's retained messages. The information returned doesn't include the message payloads of
     * the retained messages.
     * </p>
     * 
     * @param retainedTopics
     *        A summary list the account's retained messages. The information returned doesn't include the message
     *        payloads of the retained messages.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRetainedMessagesResult withRetainedTopics(java.util.Collection<RetainedMessageSummary> retainedTopics) {
        setRetainedTopics(retainedTopics);
        return this;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results, or null if there are no additional results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results, or null if there are no additional results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRetainedMessagesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRetainedTopics() != null)
            sb.append("RetainedTopics: ").append(getRetainedTopics()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListRetainedMessagesResult == false)
            return false;
        ListRetainedMessagesResult other = (ListRetainedMessagesResult) obj;
        if (other.getRetainedTopics() == null ^ this.getRetainedTopics() == null)
            return false;
        if (other.getRetainedTopics() != null && other.getRetainedTopics().equals(this.getRetainedTopics()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRetainedTopics() == null) ? 0 : getRetainedTopics().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListRetainedMessagesResult clone() {
        try {
            return (ListRetainedMessagesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
