/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * This is the <i>ACM Private CA API Reference</i>. It provides descriptions, syntax, and usage examples for each of the
 * actions and data types involved in creating and managing private certificate authorities (CA) for your organization.
 * </p>
 * <p>
 * The documentation for each action shows the Query API request parameters and the XML response. Alternatively, you can
 * use one of the AWS SDKs to access an API that's tailored to the programming language or platform that you're using.
 * For more information, see <a href="https://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.
 * </p>
 * <p>
 * Each ACM Private CA API operation has a quota that determines the number of times the operation can be called per
 * second. ACM Private CA throttles API requests at different rates depending on the operation. Throttling means that
 * ACM Private CA rejects an otherwise valid request because the request exceeds the operation's quota for the number of
 * requests per second. When a request is throttled, ACM Private CA returns a <a
 * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/CommonErrors.html">ThrottlingException</a> error. ACM
 * Private CA does not guarantee a minimum request rate for APIs.
 * </p>
 * <p>
 * To see an up-to-date list of your ACM Private CA quotas, or to request a quota increase, log into your AWS account
 * and visit the <a href="https://console.aws.amazon.com/servicequotas/">Service Quotas</a> console.
 * </p>
 */
package com.amazonaws.services.acmpca;

