/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Welcome to the Routing Control (Recovery Cluster) API Reference Guide for Amazon Route 53 Application Recovery
 * Controller.
 * </p>
 * <p>
 * With Amazon Route 53 Application Recovery Controller, you can use routing control with extreme reliability to recover
 * applications by rerouting traffic across Availability Zones or AWS Regions. Routing controls are simple on/off
 * switches hosted on a highly available cluster in Application Recovery Controller. A cluster provides a set of five
 * redundant Regional endpoints against which you can run API calls to get or update the state of routing controls. To
 * implement failover, you set one routing control on and another one off, to reroute traffic from one Availability Zone
 * or Amazon Web Services Region to another.
 * </p>
 * <p>
 * <i>Be aware that you must specify the Regional endpoints for a cluster when you work with API cluster operations to
 * get or update routing control states in Application Recovery Controller.</i> In addition, you must specify the US
 * West (Oregon) Region for Application Recovery Controller API calls. For example, use the parameter
 * <code>region us-west-2</code> with AWS CLI commands. For more information, see <a
 * href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.api.html"> Get and update routing
 * control states using the API</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
 * </p>
 * <p>
 * This API guide includes information about the API operations for how to get and update routing control states in
 * Application Recovery Controller. You also must set up the structures to support routing controls: clusters and
 * control panels.
 * </p>
 * <p>
 * For more information about working with routing control in Application Recovery Controller, see the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * To create clusters, routing controls, and control panels by using the control plane API for routing control, see the
 * <a href="https://docs.aws.amazon.com/recovery-cluster/latest/api/">Recovery Control Configuration API Reference Guide
 * for Amazon Route 53 Application Recovery Controller</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Learn about the components in recovery control configuration, including clusters, routing controls, and control
 * panels. For more information, see <a href=
 * "https://docs.aws.amazon.com/r53recovery/latest/dg/introduction-components.html#introduction-components-routing">
 * Recovery control components</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
 * </p>
 * </li>
 * <li>
 * <p>
 * Application Recovery Controller also provides readiness checks that run continually to help make sure that your
 * applications are scaled and ready to handle failover traffic. For more information about the related API actions, see
 * the <a href="https://docs.aws.amazon.com/recovery-readiness/latest/api/">Recovery Readiness API Reference Guide for
 * Amazon Route 53 Application Recovery Controller</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For more information about creating resilient applications and preparing for recovery readiness with Application
 * Recovery Controller, see the <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/">Amazon Route 53 Application
 * Recovery Controller Developer Guide</a>.
 * </p>
 * </li>
 * </ul>
 */
package com.amazonaws.services.route53recoverycluster;

