/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeModelPackageRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the model package to describe.
     * </p>
     * <p>
     * When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and -
     * (hyphen).
     * </p>
     */
    private String modelPackageName;

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the model package to describe.
     * </p>
     * <p>
     * When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and -
     * (hyphen).
     * </p>
     * 
     * @param modelPackageName
     *        The name or Amazon Resource Name (ARN) of the model package to describe.</p>
     *        <p>
     *        When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and -
     *        (hyphen).
     */

    public void setModelPackageName(String modelPackageName) {
        this.modelPackageName = modelPackageName;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the model package to describe.
     * </p>
     * <p>
     * When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and -
     * (hyphen).
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the model package to describe.</p>
     *         <p>
     *         When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and -
     *         (hyphen).
     */

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the model package to describe.
     * </p>
     * <p>
     * When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and -
     * (hyphen).
     * </p>
     * 
     * @param modelPackageName
     *        The name or Amazon Resource Name (ARN) of the model package to describe.</p>
     *        <p>
     *        When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and -
     *        (hyphen).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeModelPackageRequest withModelPackageName(String modelPackageName) {
        setModelPackageName(modelPackageName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getModelPackageName() != null)
            sb.append("ModelPackageName: ").append(getModelPackageName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeModelPackageRequest == false)
            return false;
        DescribeModelPackageRequest other = (DescribeModelPackageRequest) obj;
        if (other.getModelPackageName() == null ^ this.getModelPackageName() == null)
            return false;
        if (other.getModelPackageName() != null && other.getModelPackageName().equals(this.getModelPackageName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getModelPackageName() == null) ? 0 : getModelPackageName().hashCode());
        return hashCode;
    }

    @Override
    public DescribeModelPackageRequest clone() {
        return (DescribeModelPackageRequest) super.clone();
    }

}
