/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.frauddetector.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The time period for when the predictions were generated.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PredictionTimeRange" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PredictionTimeRange implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The start time of the time period for when the predictions were generated.
     * </p>
     */
    private String startTime;
    /**
     * <p>
     * The end time of the time period for when the predictions were generated.
     * </p>
     */
    private String endTime;

    /**
     * <p>
     * The start time of the time period for when the predictions were generated.
     * </p>
     * 
     * @param startTime
     *        The start time of the time period for when the predictions were generated.
     */

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    /**
     * <p>
     * The start time of the time period for when the predictions were generated.
     * </p>
     * 
     * @return The start time of the time period for when the predictions were generated.
     */

    public String getStartTime() {
        return this.startTime;
    }

    /**
     * <p>
     * The start time of the time period for when the predictions were generated.
     * </p>
     * 
     * @param startTime
     *        The start time of the time period for when the predictions were generated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PredictionTimeRange withStartTime(String startTime) {
        setStartTime(startTime);
        return this;
    }

    /**
     * <p>
     * The end time of the time period for when the predictions were generated.
     * </p>
     * 
     * @param endTime
     *        The end time of the time period for when the predictions were generated.
     */

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    /**
     * <p>
     * The end time of the time period for when the predictions were generated.
     * </p>
     * 
     * @return The end time of the time period for when the predictions were generated.
     */

    public String getEndTime() {
        return this.endTime;
    }

    /**
     * <p>
     * The end time of the time period for when the predictions were generated.
     * </p>
     * 
     * @param endTime
     *        The end time of the time period for when the predictions were generated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PredictionTimeRange withEndTime(String endTime) {
        setEndTime(endTime);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStartTime() != null)
            sb.append("StartTime: ").append(getStartTime()).append(",");
        if (getEndTime() != null)
            sb.append("EndTime: ").append(getEndTime());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PredictionTimeRange == false)
            return false;
        PredictionTimeRange other = (PredictionTimeRange) obj;
        if (other.getStartTime() == null ^ this.getStartTime() == null)
            return false;
        if (other.getStartTime() != null && other.getStartTime().equals(this.getStartTime()) == false)
            return false;
        if (other.getEndTime() == null ^ this.getEndTime() == null)
            return false;
        if (other.getEndTime() != null && other.getEndTime().equals(this.getEndTime()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStartTime() == null) ? 0 : getStartTime().hashCode());
        hashCode = prime * hashCode + ((getEndTime() == null) ? 0 : getEndTime().hashCode());
        return hashCode;
    }

    @Override
    public PredictionTimeRange clone() {
        try {
            return (PredictionTimeRange) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.frauddetector.model.transform.PredictionTimeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
