/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshift.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchDeleteClusterSnapshots"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BatchDeleteClusterSnapshotsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A list of identifiers for the snapshots that you want to delete.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<DeleteClusterSnapshotMessage> identifiers;

    /**
     * <p>
     * A list of identifiers for the snapshots that you want to delete.
     * </p>
     * 
     * @return A list of identifiers for the snapshots that you want to delete.
     */

    public java.util.List<DeleteClusterSnapshotMessage> getIdentifiers() {
        if (identifiers == null) {
            identifiers = new com.amazonaws.internal.SdkInternalList<DeleteClusterSnapshotMessage>();
        }
        return identifiers;
    }

    /**
     * <p>
     * A list of identifiers for the snapshots that you want to delete.
     * </p>
     * 
     * @param identifiers
     *        A list of identifiers for the snapshots that you want to delete.
     */

    public void setIdentifiers(java.util.Collection<DeleteClusterSnapshotMessage> identifiers) {
        if (identifiers == null) {
            this.identifiers = null;
            return;
        }

        this.identifiers = new com.amazonaws.internal.SdkInternalList<DeleteClusterSnapshotMessage>(identifiers);
    }

    /**
     * <p>
     * A list of identifiers for the snapshots that you want to delete.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIdentifiers(java.util.Collection)} or {@link #withIdentifiers(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param identifiers
     *        A list of identifiers for the snapshots that you want to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchDeleteClusterSnapshotsRequest withIdentifiers(DeleteClusterSnapshotMessage... identifiers) {
        if (this.identifiers == null) {
            setIdentifiers(new com.amazonaws.internal.SdkInternalList<DeleteClusterSnapshotMessage>(identifiers.length));
        }
        for (DeleteClusterSnapshotMessage ele : identifiers) {
            this.identifiers.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of identifiers for the snapshots that you want to delete.
     * </p>
     * 
     * @param identifiers
     *        A list of identifiers for the snapshots that you want to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BatchDeleteClusterSnapshotsRequest withIdentifiers(java.util.Collection<DeleteClusterSnapshotMessage> identifiers) {
        setIdentifiers(identifiers);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIdentifiers() != null)
            sb.append("Identifiers: ").append(getIdentifiers());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BatchDeleteClusterSnapshotsRequest == false)
            return false;
        BatchDeleteClusterSnapshotsRequest other = (BatchDeleteClusterSnapshotsRequest) obj;
        if (other.getIdentifiers() == null ^ this.getIdentifiers() == null)
            return false;
        if (other.getIdentifiers() != null && other.getIdentifiers().equals(this.getIdentifiers()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIdentifiers() == null) ? 0 : getIdentifiers().hashCode());
        return hashCode;
    }

    @Override
    public BatchDeleteClusterSnapshotsRequest clone() {
        return (BatchDeleteClusterSnapshotsRequest) super.clone();
    }

}
