/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspacesweb;

import javax.annotation.Generated;

import com.amazonaws.services.workspacesweb.model.*;

/**
 * Abstract implementation of {@code AmazonWorkSpacesWebAsync}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonWorkSpacesWebAsync extends AbstractAmazonWorkSpacesWeb implements AmazonWorkSpacesWebAsync {

    protected AbstractAmazonWorkSpacesWebAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateBrowserSettingsResult> associateBrowserSettingsAsync(AssociateBrowserSettingsRequest request) {

        return associateBrowserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateBrowserSettingsResult> associateBrowserSettingsAsync(AssociateBrowserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateBrowserSettingsRequest, AssociateBrowserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateNetworkSettingsResult> associateNetworkSettingsAsync(AssociateNetworkSettingsRequest request) {

        return associateNetworkSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateNetworkSettingsResult> associateNetworkSettingsAsync(AssociateNetworkSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateNetworkSettingsRequest, AssociateNetworkSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateTrustStoreResult> associateTrustStoreAsync(AssociateTrustStoreRequest request) {

        return associateTrustStoreAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateTrustStoreResult> associateTrustStoreAsync(AssociateTrustStoreRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateTrustStoreRequest, AssociateTrustStoreResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateUserSettingsResult> associateUserSettingsAsync(AssociateUserSettingsRequest request) {

        return associateUserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateUserSettingsResult> associateUserSettingsAsync(AssociateUserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateUserSettingsRequest, AssociateUserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateBrowserSettingsResult> createBrowserSettingsAsync(CreateBrowserSettingsRequest request) {

        return createBrowserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateBrowserSettingsResult> createBrowserSettingsAsync(CreateBrowserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateBrowserSettingsRequest, CreateBrowserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateIdentityProviderResult> createIdentityProviderAsync(CreateIdentityProviderRequest request) {

        return createIdentityProviderAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateIdentityProviderResult> createIdentityProviderAsync(CreateIdentityProviderRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateIdentityProviderRequest, CreateIdentityProviderResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateNetworkSettingsResult> createNetworkSettingsAsync(CreateNetworkSettingsRequest request) {

        return createNetworkSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateNetworkSettingsResult> createNetworkSettingsAsync(CreateNetworkSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateNetworkSettingsRequest, CreateNetworkSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreatePortalResult> createPortalAsync(CreatePortalRequest request) {

        return createPortalAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreatePortalResult> createPortalAsync(CreatePortalRequest request,
            com.amazonaws.handlers.AsyncHandler<CreatePortalRequest, CreatePortalResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTrustStoreResult> createTrustStoreAsync(CreateTrustStoreRequest request) {

        return createTrustStoreAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTrustStoreResult> createTrustStoreAsync(CreateTrustStoreRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTrustStoreRequest, CreateTrustStoreResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateUserSettingsResult> createUserSettingsAsync(CreateUserSettingsRequest request) {

        return createUserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateUserSettingsResult> createUserSettingsAsync(CreateUserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateUserSettingsRequest, CreateUserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteBrowserSettingsResult> deleteBrowserSettingsAsync(DeleteBrowserSettingsRequest request) {

        return deleteBrowserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBrowserSettingsResult> deleteBrowserSettingsAsync(DeleteBrowserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteBrowserSettingsRequest, DeleteBrowserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIdentityProviderResult> deleteIdentityProviderAsync(DeleteIdentityProviderRequest request) {

        return deleteIdentityProviderAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIdentityProviderResult> deleteIdentityProviderAsync(DeleteIdentityProviderRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIdentityProviderRequest, DeleteIdentityProviderResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteNetworkSettingsResult> deleteNetworkSettingsAsync(DeleteNetworkSettingsRequest request) {

        return deleteNetworkSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteNetworkSettingsResult> deleteNetworkSettingsAsync(DeleteNetworkSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkSettingsRequest, DeleteNetworkSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeletePortalResult> deletePortalAsync(DeletePortalRequest request) {

        return deletePortalAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeletePortalResult> deletePortalAsync(DeletePortalRequest request,
            com.amazonaws.handlers.AsyncHandler<DeletePortalRequest, DeletePortalResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTrustStoreResult> deleteTrustStoreAsync(DeleteTrustStoreRequest request) {

        return deleteTrustStoreAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTrustStoreResult> deleteTrustStoreAsync(DeleteTrustStoreRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTrustStoreRequest, DeleteTrustStoreResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteUserSettingsResult> deleteUserSettingsAsync(DeleteUserSettingsRequest request) {

        return deleteUserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteUserSettingsResult> deleteUserSettingsAsync(DeleteUserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteUserSettingsRequest, DeleteUserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateBrowserSettingsResult> disassociateBrowserSettingsAsync(DisassociateBrowserSettingsRequest request) {

        return disassociateBrowserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateBrowserSettingsResult> disassociateBrowserSettingsAsync(DisassociateBrowserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateBrowserSettingsRequest, DisassociateBrowserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateNetworkSettingsResult> disassociateNetworkSettingsAsync(DisassociateNetworkSettingsRequest request) {

        return disassociateNetworkSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateNetworkSettingsResult> disassociateNetworkSettingsAsync(DisassociateNetworkSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateNetworkSettingsRequest, DisassociateNetworkSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateTrustStoreResult> disassociateTrustStoreAsync(DisassociateTrustStoreRequest request) {

        return disassociateTrustStoreAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateTrustStoreResult> disassociateTrustStoreAsync(DisassociateTrustStoreRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateTrustStoreRequest, DisassociateTrustStoreResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateUserSettingsResult> disassociateUserSettingsAsync(DisassociateUserSettingsRequest request) {

        return disassociateUserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateUserSettingsResult> disassociateUserSettingsAsync(DisassociateUserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateUserSettingsRequest, DisassociateUserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBrowserSettingsResult> getBrowserSettingsAsync(GetBrowserSettingsRequest request) {

        return getBrowserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBrowserSettingsResult> getBrowserSettingsAsync(GetBrowserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBrowserSettingsRequest, GetBrowserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIdentityProviderResult> getIdentityProviderAsync(GetIdentityProviderRequest request) {

        return getIdentityProviderAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIdentityProviderResult> getIdentityProviderAsync(GetIdentityProviderRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIdentityProviderRequest, GetIdentityProviderResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetNetworkSettingsResult> getNetworkSettingsAsync(GetNetworkSettingsRequest request) {

        return getNetworkSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetNetworkSettingsResult> getNetworkSettingsAsync(GetNetworkSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetNetworkSettingsRequest, GetNetworkSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPortalResult> getPortalAsync(GetPortalRequest request) {

        return getPortalAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPortalResult> getPortalAsync(GetPortalRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPortalRequest, GetPortalResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPortalServiceProviderMetadataResult> getPortalServiceProviderMetadataAsync(
            GetPortalServiceProviderMetadataRequest request) {

        return getPortalServiceProviderMetadataAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPortalServiceProviderMetadataResult> getPortalServiceProviderMetadataAsync(
            GetPortalServiceProviderMetadataRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPortalServiceProviderMetadataRequest, GetPortalServiceProviderMetadataResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTrustStoreResult> getTrustStoreAsync(GetTrustStoreRequest request) {

        return getTrustStoreAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTrustStoreResult> getTrustStoreAsync(GetTrustStoreRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTrustStoreRequest, GetTrustStoreResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTrustStoreCertificateResult> getTrustStoreCertificateAsync(GetTrustStoreCertificateRequest request) {

        return getTrustStoreCertificateAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTrustStoreCertificateResult> getTrustStoreCertificateAsync(GetTrustStoreCertificateRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTrustStoreCertificateRequest, GetTrustStoreCertificateResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetUserSettingsResult> getUserSettingsAsync(GetUserSettingsRequest request) {

        return getUserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetUserSettingsResult> getUserSettingsAsync(GetUserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetUserSettingsRequest, GetUserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListBrowserSettingsResult> listBrowserSettingsAsync(ListBrowserSettingsRequest request) {

        return listBrowserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListBrowserSettingsResult> listBrowserSettingsAsync(ListBrowserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListBrowserSettingsRequest, ListBrowserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListIdentityProvidersResult> listIdentityProvidersAsync(ListIdentityProvidersRequest request) {

        return listIdentityProvidersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListIdentityProvidersResult> listIdentityProvidersAsync(ListIdentityProvidersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListIdentityProvidersRequest, ListIdentityProvidersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListNetworkSettingsResult> listNetworkSettingsAsync(ListNetworkSettingsRequest request) {

        return listNetworkSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListNetworkSettingsResult> listNetworkSettingsAsync(ListNetworkSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListNetworkSettingsRequest, ListNetworkSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPortalsResult> listPortalsAsync(ListPortalsRequest request) {

        return listPortalsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPortalsResult> listPortalsAsync(ListPortalsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPortalsRequest, ListPortalsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTrustStoreCertificatesResult> listTrustStoreCertificatesAsync(ListTrustStoreCertificatesRequest request) {

        return listTrustStoreCertificatesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTrustStoreCertificatesResult> listTrustStoreCertificatesAsync(ListTrustStoreCertificatesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTrustStoreCertificatesRequest, ListTrustStoreCertificatesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTrustStoresResult> listTrustStoresAsync(ListTrustStoresRequest request) {

        return listTrustStoresAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTrustStoresResult> listTrustStoresAsync(ListTrustStoresRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTrustStoresRequest, ListTrustStoresResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListUserSettingsResult> listUserSettingsAsync(ListUserSettingsRequest request) {

        return listUserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListUserSettingsResult> listUserSettingsAsync(ListUserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListUserSettingsRequest, ListUserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateBrowserSettingsResult> updateBrowserSettingsAsync(UpdateBrowserSettingsRequest request) {

        return updateBrowserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateBrowserSettingsResult> updateBrowserSettingsAsync(UpdateBrowserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateBrowserSettingsRequest, UpdateBrowserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateIdentityProviderResult> updateIdentityProviderAsync(UpdateIdentityProviderRequest request) {

        return updateIdentityProviderAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateIdentityProviderResult> updateIdentityProviderAsync(UpdateIdentityProviderRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateIdentityProviderRequest, UpdateIdentityProviderResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateNetworkSettingsResult> updateNetworkSettingsAsync(UpdateNetworkSettingsRequest request) {

        return updateNetworkSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateNetworkSettingsResult> updateNetworkSettingsAsync(UpdateNetworkSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateNetworkSettingsRequest, UpdateNetworkSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePortalResult> updatePortalAsync(UpdatePortalRequest request) {

        return updatePortalAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePortalResult> updatePortalAsync(UpdatePortalRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePortalRequest, UpdatePortalResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTrustStoreResult> updateTrustStoreAsync(UpdateTrustStoreRequest request) {

        return updateTrustStoreAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTrustStoreResult> updateTrustStoreAsync(UpdateTrustStoreRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTrustStoreRequest, UpdateTrustStoreResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateUserSettingsResult> updateUserSettingsAsync(UpdateUserSettingsRequest request) {

        return updateUserSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateUserSettingsResult> updateUserSettingsAsync(UpdateUserSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateUserSettingsRequest, UpdateUserSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
