/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudwatchevidently;

import javax.annotation.Generated;

import com.amazonaws.services.cloudwatchevidently.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonCloudWatchEvidently}. Convenient method forms pass through to the
 * corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonCloudWatchEvidently implements AmazonCloudWatchEvidently {

    protected AbstractAmazonCloudWatchEvidently() {
    }

    @Override
    public BatchEvaluateFeatureResult batchEvaluateFeature(BatchEvaluateFeatureRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateExperimentResult createExperiment(CreateExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFeatureResult createFeature(CreateFeatureRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLaunchResult createLaunch(CreateLaunchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteExperimentResult deleteExperiment(DeleteExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFeatureResult deleteFeature(DeleteFeatureRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLaunchResult deleteLaunch(DeleteLaunchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EvaluateFeatureResult evaluateFeature(EvaluateFeatureRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetExperimentResult getExperiment(GetExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetExperimentResultsResult getExperimentResults(GetExperimentResultsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFeatureResult getFeature(GetFeatureRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLaunchResult getLaunch(GetLaunchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProjectResult getProject(GetProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExperimentsResult listExperiments(ListExperimentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFeaturesResult listFeatures(ListFeaturesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLaunchesResult listLaunches(ListLaunchesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutProjectEventsResult putProjectEvents(PutProjectEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartExperimentResult startExperiment(StartExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartLaunchResult startLaunch(StartLaunchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopExperimentResult stopExperiment(StopExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopLaunchResult stopLaunch(StopLaunchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateExperimentResult updateExperiment(UpdateExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFeatureResult updateFeature(UpdateFeatureRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLaunchResult updateLaunch(UpdateLaunchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProjectDataDeliveryResult updateProjectDataDelivery(UpdateProjectDataDeliveryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
