/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Object for LoRaWAN join resource type event configuration.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/LoRaWANJoinEventNotificationConfigurations"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class LoRaWANJoinEventNotificationConfigurations implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Enum to denote whether the dev eui join event topic is enabled or disabled.
     * </p>
     */
    private String devEuiEventTopic;

    /**
     * <p>
     * Enum to denote whether the dev eui join event topic is enabled or disabled.
     * </p>
     * 
     * @param devEuiEventTopic
     *        Enum to denote whether the dev eui join event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */

    public void setDevEuiEventTopic(String devEuiEventTopic) {
        this.devEuiEventTopic = devEuiEventTopic;
    }

    /**
     * <p>
     * Enum to denote whether the dev eui join event topic is enabled or disabled.
     * </p>
     * 
     * @return Enum to denote whether the dev eui join event topic is enabled or disabled.
     * @see EventNotificationTopicStatus
     */

    public String getDevEuiEventTopic() {
        return this.devEuiEventTopic;
    }

    /**
     * <p>
     * Enum to denote whether the dev eui join event topic is enabled or disabled.
     * </p>
     * 
     * @param devEuiEventTopic
     *        Enum to denote whether the dev eui join event topic is enabled or disabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EventNotificationTopicStatus
     */

    public LoRaWANJoinEventNotificationConfigurations withDevEuiEventTopic(String devEuiEventTopic) {
        setDevEuiEventTopic(devEuiEventTopic);
        return this;
    }

    /**
     * <p>
     * Enum to denote whether the dev eui join event topic is enabled or disabled.
     * </p>
     * 
     * @param devEuiEventTopic
     *        Enum to denote whether the dev eui join event topic is enabled or disabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EventNotificationTopicStatus
     */

    public LoRaWANJoinEventNotificationConfigurations withDevEuiEventTopic(EventNotificationTopicStatus devEuiEventTopic) {
        this.devEuiEventTopic = devEuiEventTopic.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDevEuiEventTopic() != null)
            sb.append("DevEuiEventTopic: ").append(getDevEuiEventTopic());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof LoRaWANJoinEventNotificationConfigurations == false)
            return false;
        LoRaWANJoinEventNotificationConfigurations other = (LoRaWANJoinEventNotificationConfigurations) obj;
        if (other.getDevEuiEventTopic() == null ^ this.getDevEuiEventTopic() == null)
            return false;
        if (other.getDevEuiEventTopic() != null && other.getDevEuiEventTopic().equals(this.getDevEuiEventTopic()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDevEuiEventTopic() == null) ? 0 : getDevEuiEventTopic().hashCode());
        return hashCode;
    }

    @Override
    public LoRaWANJoinEventNotificationConfigurations clone() {
        try {
            return (LoRaWANJoinEventNotificationConfigurations) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.iotwireless.model.transform.LoRaWANJoinEventNotificationConfigurationsMarshaller.getInstance()
                .marshall(this, protocolMarshaller);
    }
}
