/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearch.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Container for the parameters to the <code> <a>UpdateDomain</a> </code> operation. Specifies the type and number of
 * instances in the domain cluster.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateDomainConfigRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the domain you're updating.
     * </p>
     */
    private String domainName;
    /**
     * <p>
     * The type and number of instances to instantiate for the domain cluster.
     * </p>
     */
    private ClusterConfig clusterConfig;
    /**
     * <p>
     * Specify the type and size of the EBS volume to use.
     * </p>
     */
    private EBSOptions eBSOptions;
    /**
     * <p>
     * Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours.
     * </p>
     */
    private SnapshotOptions snapshotOptions;
    /**
     * <p>
     * Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a
     * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching
     * your Amazon OpenSearch Service domains using a VPC </a>.
     * </p>
     */
    private VPCOptions vPCOptions;
    /**
     * <p>
     * Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more
     * information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
     * target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
     * </p>
     */
    private CognitoOptions cognitoOptions;
    /**
     * <p>
     * Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code>
     * when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href=
     * "http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     * target="_blank">Advanced options </a> for more information.
     * </p>
     */
    private java.util.Map<String, String> advancedOptions;
    /**
     * <p>
     * IAM access policy as a JSON-formatted string.
     * </p>
     */
    private String accessPolicies;
    /**
     * <p>
     * Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type
     * of OpenSearch log.
     * </p>
     */
    private java.util.Map<String, LogPublishingOption> logPublishingOptions;
    /**
     * <p>
     * Specifies encryption of data at rest options.
     * </p>
     */
    private EncryptionAtRestOptions encryptionAtRestOptions;
    /**
     * <p>
     * Options to specify configuration that will be applied to the domain endpoint.
     * </p>
     */
    private DomainEndpointOptions domainEndpointOptions;
    /**
     * <p>
     * Specifies node-to-node encryption options.
     * </p>
     */
    private NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
    /**
     * <p>
     * Specifies advanced security options.
     * </p>
     */
    private AdvancedSecurityOptionsInput advancedSecurityOptions;
    /**
     * <p>
     * Specifies Auto-Tune options.
     * </p>
     */
    private AutoTuneOptions autoTuneOptions;
    /**
     * <p>
     * This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of
     * validation checks (DryRunResults) without actually applying the change.
     * </p>
     */
    private Boolean dryRun;

    /**
     * <p>
     * The name of the domain you're updating.
     * </p>
     * 
     * @param domainName
     *        The name of the domain you're updating.
     */

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    /**
     * <p>
     * The name of the domain you're updating.
     * </p>
     * 
     * @return The name of the domain you're updating.
     */

    public String getDomainName() {
        return this.domainName;
    }

    /**
     * <p>
     * The name of the domain you're updating.
     * </p>
     * 
     * @param domainName
     *        The name of the domain you're updating.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withDomainName(String domainName) {
        setDomainName(domainName);
        return this;
    }

    /**
     * <p>
     * The type and number of instances to instantiate for the domain cluster.
     * </p>
     * 
     * @param clusterConfig
     *        The type and number of instances to instantiate for the domain cluster.
     */

    public void setClusterConfig(ClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
    }

    /**
     * <p>
     * The type and number of instances to instantiate for the domain cluster.
     * </p>
     * 
     * @return The type and number of instances to instantiate for the domain cluster.
     */

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    /**
     * <p>
     * The type and number of instances to instantiate for the domain cluster.
     * </p>
     * 
     * @param clusterConfig
     *        The type and number of instances to instantiate for the domain cluster.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withClusterConfig(ClusterConfig clusterConfig) {
        setClusterConfig(clusterConfig);
        return this;
    }

    /**
     * <p>
     * Specify the type and size of the EBS volume to use.
     * </p>
     * 
     * @param eBSOptions
     *        Specify the type and size of the EBS volume to use.
     */

    public void setEBSOptions(EBSOptions eBSOptions) {
        this.eBSOptions = eBSOptions;
    }

    /**
     * <p>
     * Specify the type and size of the EBS volume to use.
     * </p>
     * 
     * @return Specify the type and size of the EBS volume to use.
     */

    public EBSOptions getEBSOptions() {
        return this.eBSOptions;
    }

    /**
     * <p>
     * Specify the type and size of the EBS volume to use.
     * </p>
     * 
     * @param eBSOptions
     *        Specify the type and size of the EBS volume to use.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withEBSOptions(EBSOptions eBSOptions) {
        setEBSOptions(eBSOptions);
        return this;
    }

    /**
     * <p>
     * Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours.
     * </p>
     * 
     * @param snapshotOptions
     *        Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code>
     *        hours.
     */

    public void setSnapshotOptions(SnapshotOptions snapshotOptions) {
        this.snapshotOptions = snapshotOptions;
    }

    /**
     * <p>
     * Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours.
     * </p>
     * 
     * @return Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code>
     *         hours.
     */

    public SnapshotOptions getSnapshotOptions() {
        return this.snapshotOptions;
    }

    /**
     * <p>
     * Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours.
     * </p>
     * 
     * @param snapshotOptions
     *        Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code>
     *        hours.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withSnapshotOptions(SnapshotOptions snapshotOptions) {
        setSnapshotOptions(snapshotOptions);
        return this;
    }

    /**
     * <p>
     * Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a
     * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching
     * your Amazon OpenSearch Service domains using a VPC </a>.
     * </p>
     * 
     * @param vPCOptions
     *        Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a
     *        href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html"
     *        target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>.
     */

    public void setVPCOptions(VPCOptions vPCOptions) {
        this.vPCOptions = vPCOptions;
    }

    /**
     * <p>
     * Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a
     * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching
     * your Amazon OpenSearch Service domains using a VPC </a>.
     * </p>
     * 
     * @return Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a
     *         href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html"
     *         target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>.
     */

    public VPCOptions getVPCOptions() {
        return this.vPCOptions;
    }

    /**
     * <p>
     * Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a
     * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">Launching
     * your Amazon OpenSearch Service domains using a VPC </a>.
     * </p>
     * 
     * @param vPCOptions
     *        Options to specify the subnets and security groups for the VPC endpoint. For more information, see <a
     *        href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html"
     *        target="_blank">Launching your Amazon OpenSearch Service domains using a VPC </a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withVPCOptions(VPCOptions vPCOptions) {
        setVPCOptions(vPCOptions);
        return this;
    }

    /**
     * <p>
     * Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more
     * information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
     * target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
     * </p>
     * 
     * @param cognitoOptions
     *        Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more
     *        information, see <a
     *        href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
     *        target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
     */

    public void setCognitoOptions(CognitoOptions cognitoOptions) {
        this.cognitoOptions = cognitoOptions;
    }

    /**
     * <p>
     * Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more
     * information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
     * target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
     * </p>
     * 
     * @return Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
     *         target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
     */

    public CognitoOptions getCognitoOptions() {
        return this.cognitoOptions;
    }

    /**
     * <p>
     * Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more
     * information, see <a href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
     * target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
     * </p>
     * 
     * @param cognitoOptions
     *        Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more
     *        information, see <a
     *        href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
     *        target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withCognitoOptions(CognitoOptions cognitoOptions) {
        setCognitoOptions(cognitoOptions);
        return this;
    }

    /**
     * <p>
     * Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code>
     * when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href=
     * "http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     * target="_blank">Advanced options </a> for more information.
     * </p>
     * 
     * @return Modifies the advanced option to allow references to indices in an HTTP request body. Must be
     *         <code>false</code> when configuring access to individual sub-resources. By default, the value is
     *         <code>true</code>. See <a href=
     *         "http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     *         target="_blank">Advanced options </a> for more information.
     */

    public java.util.Map<String, String> getAdvancedOptions() {
        return advancedOptions;
    }

    /**
     * <p>
     * Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code>
     * when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href=
     * "http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     * target="_blank">Advanced options </a> for more information.
     * </p>
     * 
     * @param advancedOptions
     *        Modifies the advanced option to allow references to indices in an HTTP request body. Must be
     *        <code>false</code> when configuring access to individual sub-resources. By default, the value is
     *        <code>true</code>. See <a href=
     *        "http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     *        target="_blank">Advanced options </a> for more information.
     */

    public void setAdvancedOptions(java.util.Map<String, String> advancedOptions) {
        this.advancedOptions = advancedOptions;
    }

    /**
     * <p>
     * Modifies the advanced option to allow references to indices in an HTTP request body. Must be <code>false</code>
     * when configuring access to individual sub-resources. By default, the value is <code>true</code>. See <a href=
     * "http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     * target="_blank">Advanced options </a> for more information.
     * </p>
     * 
     * @param advancedOptions
     *        Modifies the advanced option to allow references to indices in an HTTP request body. Must be
     *        <code>false</code> when configuring access to individual sub-resources. By default, the value is
     *        <code>true</code>. See <a href=
     *        "http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     *        target="_blank">Advanced options </a> for more information.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withAdvancedOptions(java.util.Map<String, String> advancedOptions) {
        setAdvancedOptions(advancedOptions);
        return this;
    }

    /**
     * Add a single AdvancedOptions entry
     *
     * @see UpdateDomainConfigRequest#withAdvancedOptions
     * @returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest addAdvancedOptionsEntry(String key, String value) {
        if (null == this.advancedOptions) {
            this.advancedOptions = new java.util.HashMap<String, String>();
        }
        if (this.advancedOptions.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.advancedOptions.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into AdvancedOptions.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest clearAdvancedOptionsEntries() {
        this.advancedOptions = null;
        return this;
    }

    /**
     * <p>
     * IAM access policy as a JSON-formatted string.
     * </p>
     * 
     * @param accessPolicies
     *        IAM access policy as a JSON-formatted string.
     */

    public void setAccessPolicies(String accessPolicies) {
        this.accessPolicies = accessPolicies;
    }

    /**
     * <p>
     * IAM access policy as a JSON-formatted string.
     * </p>
     * 
     * @return IAM access policy as a JSON-formatted string.
     */

    public String getAccessPolicies() {
        return this.accessPolicies;
    }

    /**
     * <p>
     * IAM access policy as a JSON-formatted string.
     * </p>
     * 
     * @param accessPolicies
     *        IAM access policy as a JSON-formatted string.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withAccessPolicies(String accessPolicies) {
        setAccessPolicies(accessPolicies);
        return this;
    }

    /**
     * <p>
     * Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type
     * of OpenSearch log.
     * </p>
     * 
     * @return Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a
     *         given type of OpenSearch log.
     */

    public java.util.Map<String, LogPublishingOption> getLogPublishingOptions() {
        return logPublishingOptions;
    }

    /**
     * <p>
     * Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type
     * of OpenSearch log.
     * </p>
     * 
     * @param logPublishingOptions
     *        Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a
     *        given type of OpenSearch log.
     */

    public void setLogPublishingOptions(java.util.Map<String, LogPublishingOption> logPublishingOptions) {
        this.logPublishingOptions = logPublishingOptions;
    }

    /**
     * <p>
     * Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a given type
     * of OpenSearch log.
     * </p>
     * 
     * @param logPublishingOptions
     *        Map of <code>LogType</code> and <code>LogPublishingOption</code>, each containing options to publish a
     *        given type of OpenSearch log.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withLogPublishingOptions(java.util.Map<String, LogPublishingOption> logPublishingOptions) {
        setLogPublishingOptions(logPublishingOptions);
        return this;
    }

    /**
     * Add a single LogPublishingOptions entry
     *
     * @see UpdateDomainConfigRequest#withLogPublishingOptions
     * @returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest addLogPublishingOptionsEntry(String key, LogPublishingOption value) {
        if (null == this.logPublishingOptions) {
            this.logPublishingOptions = new java.util.HashMap<String, LogPublishingOption>();
        }
        if (this.logPublishingOptions.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.logPublishingOptions.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into LogPublishingOptions.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest clearLogPublishingOptionsEntries() {
        this.logPublishingOptions = null;
        return this;
    }

    /**
     * <p>
     * Specifies encryption of data at rest options.
     * </p>
     * 
     * @param encryptionAtRestOptions
     *        Specifies encryption of data at rest options.
     */

    public void setEncryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
        this.encryptionAtRestOptions = encryptionAtRestOptions;
    }

    /**
     * <p>
     * Specifies encryption of data at rest options.
     * </p>
     * 
     * @return Specifies encryption of data at rest options.
     */

    public EncryptionAtRestOptions getEncryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    /**
     * <p>
     * Specifies encryption of data at rest options.
     * </p>
     * 
     * @param encryptionAtRestOptions
     *        Specifies encryption of data at rest options.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withEncryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
        setEncryptionAtRestOptions(encryptionAtRestOptions);
        return this;
    }

    /**
     * <p>
     * Options to specify configuration that will be applied to the domain endpoint.
     * </p>
     * 
     * @param domainEndpointOptions
     *        Options to specify configuration that will be applied to the domain endpoint.
     */

    public void setDomainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
        this.domainEndpointOptions = domainEndpointOptions;
    }

    /**
     * <p>
     * Options to specify configuration that will be applied to the domain endpoint.
     * </p>
     * 
     * @return Options to specify configuration that will be applied to the domain endpoint.
     */

    public DomainEndpointOptions getDomainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    /**
     * <p>
     * Options to specify configuration that will be applied to the domain endpoint.
     * </p>
     * 
     * @param domainEndpointOptions
     *        Options to specify configuration that will be applied to the domain endpoint.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withDomainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
        setDomainEndpointOptions(domainEndpointOptions);
        return this;
    }

    /**
     * <p>
     * Specifies node-to-node encryption options.
     * </p>
     * 
     * @param nodeToNodeEncryptionOptions
     *        Specifies node-to-node encryption options.
     */

    public void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
        this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
    }

    /**
     * <p>
     * Specifies node-to-node encryption options.
     * </p>
     * 
     * @return Specifies node-to-node encryption options.
     */

    public NodeToNodeEncryptionOptions getNodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    /**
     * <p>
     * Specifies node-to-node encryption options.
     * </p>
     * 
     * @param nodeToNodeEncryptionOptions
     *        Specifies node-to-node encryption options.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
        setNodeToNodeEncryptionOptions(nodeToNodeEncryptionOptions);
        return this;
    }

    /**
     * <p>
     * Specifies advanced security options.
     * </p>
     * 
     * @param advancedSecurityOptions
     *        Specifies advanced security options.
     */

    public void setAdvancedSecurityOptions(AdvancedSecurityOptionsInput advancedSecurityOptions) {
        this.advancedSecurityOptions = advancedSecurityOptions;
    }

    /**
     * <p>
     * Specifies advanced security options.
     * </p>
     * 
     * @return Specifies advanced security options.
     */

    public AdvancedSecurityOptionsInput getAdvancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    /**
     * <p>
     * Specifies advanced security options.
     * </p>
     * 
     * @param advancedSecurityOptions
     *        Specifies advanced security options.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withAdvancedSecurityOptions(AdvancedSecurityOptionsInput advancedSecurityOptions) {
        setAdvancedSecurityOptions(advancedSecurityOptions);
        return this;
    }

    /**
     * <p>
     * Specifies Auto-Tune options.
     * </p>
     * 
     * @param autoTuneOptions
     *        Specifies Auto-Tune options.
     */

    public void setAutoTuneOptions(AutoTuneOptions autoTuneOptions) {
        this.autoTuneOptions = autoTuneOptions;
    }

    /**
     * <p>
     * Specifies Auto-Tune options.
     * </p>
     * 
     * @return Specifies Auto-Tune options.
     */

    public AutoTuneOptions getAutoTuneOptions() {
        return this.autoTuneOptions;
    }

    /**
     * <p>
     * Specifies Auto-Tune options.
     * </p>
     * 
     * @param autoTuneOptions
     *        Specifies Auto-Tune options.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withAutoTuneOptions(AutoTuneOptions autoTuneOptions) {
        setAutoTuneOptions(autoTuneOptions);
        return this;
    }

    /**
     * <p>
     * This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of
     * validation checks (DryRunResults) without actually applying the change.
     * </p>
     * 
     * @param dryRun
     *        This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the
     *        results of validation checks (DryRunResults) without actually applying the change.
     */

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    /**
     * <p>
     * This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of
     * validation checks (DryRunResults) without actually applying the change.
     * </p>
     * 
     * @return This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the
     *         results of validation checks (DryRunResults) without actually applying the change.
     */

    public Boolean getDryRun() {
        return this.dryRun;
    }

    /**
     * <p>
     * This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of
     * validation checks (DryRunResults) without actually applying the change.
     * </p>
     * 
     * @param dryRun
     *        This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the
     *        results of validation checks (DryRunResults) without actually applying the change.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateDomainConfigRequest withDryRun(Boolean dryRun) {
        setDryRun(dryRun);
        return this;
    }

    /**
     * <p>
     * This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of
     * validation checks (DryRunResults) without actually applying the change.
     * </p>
     * 
     * @return This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the
     *         results of validation checks (DryRunResults) without actually applying the change.
     */

    public Boolean isDryRun() {
        return this.dryRun;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDomainName() != null)
            sb.append("DomainName: ").append(getDomainName()).append(",");
        if (getClusterConfig() != null)
            sb.append("ClusterConfig: ").append(getClusterConfig()).append(",");
        if (getEBSOptions() != null)
            sb.append("EBSOptions: ").append(getEBSOptions()).append(",");
        if (getSnapshotOptions() != null)
            sb.append("SnapshotOptions: ").append(getSnapshotOptions()).append(",");
        if (getVPCOptions() != null)
            sb.append("VPCOptions: ").append(getVPCOptions()).append(",");
        if (getCognitoOptions() != null)
            sb.append("CognitoOptions: ").append(getCognitoOptions()).append(",");
        if (getAdvancedOptions() != null)
            sb.append("AdvancedOptions: ").append(getAdvancedOptions()).append(",");
        if (getAccessPolicies() != null)
            sb.append("AccessPolicies: ").append(getAccessPolicies()).append(",");
        if (getLogPublishingOptions() != null)
            sb.append("LogPublishingOptions: ").append(getLogPublishingOptions()).append(",");
        if (getEncryptionAtRestOptions() != null)
            sb.append("EncryptionAtRestOptions: ").append(getEncryptionAtRestOptions()).append(",");
        if (getDomainEndpointOptions() != null)
            sb.append("DomainEndpointOptions: ").append(getDomainEndpointOptions()).append(",");
        if (getNodeToNodeEncryptionOptions() != null)
            sb.append("NodeToNodeEncryptionOptions: ").append(getNodeToNodeEncryptionOptions()).append(",");
        if (getAdvancedSecurityOptions() != null)
            sb.append("AdvancedSecurityOptions: ").append(getAdvancedSecurityOptions()).append(",");
        if (getAutoTuneOptions() != null)
            sb.append("AutoTuneOptions: ").append(getAutoTuneOptions()).append(",");
        if (getDryRun() != null)
            sb.append("DryRun: ").append(getDryRun());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateDomainConfigRequest == false)
            return false;
        UpdateDomainConfigRequest other = (UpdateDomainConfigRequest) obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null)
            return false;
        if (other.getDomainName() != null && other.getDomainName().equals(this.getDomainName()) == false)
            return false;
        if (other.getClusterConfig() == null ^ this.getClusterConfig() == null)
            return false;
        if (other.getClusterConfig() != null && other.getClusterConfig().equals(this.getClusterConfig()) == false)
            return false;
        if (other.getEBSOptions() == null ^ this.getEBSOptions() == null)
            return false;
        if (other.getEBSOptions() != null && other.getEBSOptions().equals(this.getEBSOptions()) == false)
            return false;
        if (other.getSnapshotOptions() == null ^ this.getSnapshotOptions() == null)
            return false;
        if (other.getSnapshotOptions() != null && other.getSnapshotOptions().equals(this.getSnapshotOptions()) == false)
            return false;
        if (other.getVPCOptions() == null ^ this.getVPCOptions() == null)
            return false;
        if (other.getVPCOptions() != null && other.getVPCOptions().equals(this.getVPCOptions()) == false)
            return false;
        if (other.getCognitoOptions() == null ^ this.getCognitoOptions() == null)
            return false;
        if (other.getCognitoOptions() != null && other.getCognitoOptions().equals(this.getCognitoOptions()) == false)
            return false;
        if (other.getAdvancedOptions() == null ^ this.getAdvancedOptions() == null)
            return false;
        if (other.getAdvancedOptions() != null && other.getAdvancedOptions().equals(this.getAdvancedOptions()) == false)
            return false;
        if (other.getAccessPolicies() == null ^ this.getAccessPolicies() == null)
            return false;
        if (other.getAccessPolicies() != null && other.getAccessPolicies().equals(this.getAccessPolicies()) == false)
            return false;
        if (other.getLogPublishingOptions() == null ^ this.getLogPublishingOptions() == null)
            return false;
        if (other.getLogPublishingOptions() != null && other.getLogPublishingOptions().equals(this.getLogPublishingOptions()) == false)
            return false;
        if (other.getEncryptionAtRestOptions() == null ^ this.getEncryptionAtRestOptions() == null)
            return false;
        if (other.getEncryptionAtRestOptions() != null && other.getEncryptionAtRestOptions().equals(this.getEncryptionAtRestOptions()) == false)
            return false;
        if (other.getDomainEndpointOptions() == null ^ this.getDomainEndpointOptions() == null)
            return false;
        if (other.getDomainEndpointOptions() != null && other.getDomainEndpointOptions().equals(this.getDomainEndpointOptions()) == false)
            return false;
        if (other.getNodeToNodeEncryptionOptions() == null ^ this.getNodeToNodeEncryptionOptions() == null)
            return false;
        if (other.getNodeToNodeEncryptionOptions() != null && other.getNodeToNodeEncryptionOptions().equals(this.getNodeToNodeEncryptionOptions()) == false)
            return false;
        if (other.getAdvancedSecurityOptions() == null ^ this.getAdvancedSecurityOptions() == null)
            return false;
        if (other.getAdvancedSecurityOptions() != null && other.getAdvancedSecurityOptions().equals(this.getAdvancedSecurityOptions()) == false)
            return false;
        if (other.getAutoTuneOptions() == null ^ this.getAutoTuneOptions() == null)
            return false;
        if (other.getAutoTuneOptions() != null && other.getAutoTuneOptions().equals(this.getAutoTuneOptions()) == false)
            return false;
        if (other.getDryRun() == null ^ this.getDryRun() == null)
            return false;
        if (other.getDryRun() != null && other.getDryRun().equals(this.getDryRun()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDomainName() == null) ? 0 : getDomainName().hashCode());
        hashCode = prime * hashCode + ((getClusterConfig() == null) ? 0 : getClusterConfig().hashCode());
        hashCode = prime * hashCode + ((getEBSOptions() == null) ? 0 : getEBSOptions().hashCode());
        hashCode = prime * hashCode + ((getSnapshotOptions() == null) ? 0 : getSnapshotOptions().hashCode());
        hashCode = prime * hashCode + ((getVPCOptions() == null) ? 0 : getVPCOptions().hashCode());
        hashCode = prime * hashCode + ((getCognitoOptions() == null) ? 0 : getCognitoOptions().hashCode());
        hashCode = prime * hashCode + ((getAdvancedOptions() == null) ? 0 : getAdvancedOptions().hashCode());
        hashCode = prime * hashCode + ((getAccessPolicies() == null) ? 0 : getAccessPolicies().hashCode());
        hashCode = prime * hashCode + ((getLogPublishingOptions() == null) ? 0 : getLogPublishingOptions().hashCode());
        hashCode = prime * hashCode + ((getEncryptionAtRestOptions() == null) ? 0 : getEncryptionAtRestOptions().hashCode());
        hashCode = prime * hashCode + ((getDomainEndpointOptions() == null) ? 0 : getDomainEndpointOptions().hashCode());
        hashCode = prime * hashCode + ((getNodeToNodeEncryptionOptions() == null) ? 0 : getNodeToNodeEncryptionOptions().hashCode());
        hashCode = prime * hashCode + ((getAdvancedSecurityOptions() == null) ? 0 : getAdvancedSecurityOptions().hashCode());
        hashCode = prime * hashCode + ((getAutoTuneOptions() == null) ? 0 : getAutoTuneOptions().hashCode());
        hashCode = prime * hashCode + ((getDryRun() == null) ? 0 : getDryRun().hashCode());
        return hashCode;
    }

    @Override
    public UpdateDomainConfigRequest clone() {
        return (UpdateDomainConfigRequest) super.clone();
    }

}
