/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.finspacedata;

import javax.annotation.Generated;

import com.amazonaws.services.finspacedata.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSFinSpaceData}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSFinSpaceData implements AWSFinSpaceData {

    protected AbstractAWSFinSpaceData() {
    }

    @Override
    public CreateChangesetResult createChangeset(CreateChangesetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataViewResult createDataView(CreateDataViewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePermissionGroupResult createPermissionGroup(CreatePermissionGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePermissionGroupResult deletePermissionGroup(DeletePermissionGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableUserResult disableUser(DisableUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableUserResult enableUser(EnableUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChangesetResult getChangeset(GetChangesetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataViewResult getDataView(GetDataViewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatasetResult getDataset(GetDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProgrammaticAccessCredentialsResult getProgrammaticAccessCredentials(GetProgrammaticAccessCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserResult getUser(GetUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkingLocationResult getWorkingLocation(GetWorkingLocationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChangesetsResult listChangesets(ListChangesetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataViewsResult listDataViews(ListDataViewsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPermissionGroupsResult listPermissionGroups(ListPermissionGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetUserPasswordResult resetUserPassword(ResetUserPasswordRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChangesetResult updateChangeset(UpdateChangesetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatasetResult updateDataset(UpdateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePermissionGroupResult updatePermissionGroup(UpdatePermissionGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
