/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePhoneNumber" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribePhoneNumberResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Information about a phone number that's been claimed to your Amazon Connect instance.
     * </p>
     */
    private ClaimedPhoneNumberSummary claimedPhoneNumberSummary;

    /**
     * <p>
     * Information about a phone number that's been claimed to your Amazon Connect instance.
     * </p>
     * 
     * @param claimedPhoneNumberSummary
     *        Information about a phone number that's been claimed to your Amazon Connect instance.
     */

    public void setClaimedPhoneNumberSummary(ClaimedPhoneNumberSummary claimedPhoneNumberSummary) {
        this.claimedPhoneNumberSummary = claimedPhoneNumberSummary;
    }

    /**
     * <p>
     * Information about a phone number that's been claimed to your Amazon Connect instance.
     * </p>
     * 
     * @return Information about a phone number that's been claimed to your Amazon Connect instance.
     */

    public ClaimedPhoneNumberSummary getClaimedPhoneNumberSummary() {
        return this.claimedPhoneNumberSummary;
    }

    /**
     * <p>
     * Information about a phone number that's been claimed to your Amazon Connect instance.
     * </p>
     * 
     * @param claimedPhoneNumberSummary
     *        Information about a phone number that's been claimed to your Amazon Connect instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribePhoneNumberResult withClaimedPhoneNumberSummary(ClaimedPhoneNumberSummary claimedPhoneNumberSummary) {
        setClaimedPhoneNumberSummary(claimedPhoneNumberSummary);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClaimedPhoneNumberSummary() != null)
            sb.append("ClaimedPhoneNumberSummary: ").append(getClaimedPhoneNumberSummary());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribePhoneNumberResult == false)
            return false;
        DescribePhoneNumberResult other = (DescribePhoneNumberResult) obj;
        if (other.getClaimedPhoneNumberSummary() == null ^ this.getClaimedPhoneNumberSummary() == null)
            return false;
        if (other.getClaimedPhoneNumberSummary() != null && other.getClaimedPhoneNumberSummary().equals(this.getClaimedPhoneNumberSummary()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClaimedPhoneNumberSummary() == null) ? 0 : getClaimedPhoneNumberSummary().hashCode());
        return hashCode;
    }

    @Override
    public DescribePhoneNumberResult clone() {
        try {
            return (DescribePhoneNumberResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
