/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftserverless.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshiftserverless-2021-04-21/GetRecoveryPoint"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetRecoveryPointResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The returned recovery point object.
     * </p>
     */
    private RecoveryPoint recoveryPoint;

    /**
     * <p>
     * The returned recovery point object.
     * </p>
     * 
     * @param recoveryPoint
     *        The returned recovery point object.
     */

    public void setRecoveryPoint(RecoveryPoint recoveryPoint) {
        this.recoveryPoint = recoveryPoint;
    }

    /**
     * <p>
     * The returned recovery point object.
     * </p>
     * 
     * @return The returned recovery point object.
     */

    public RecoveryPoint getRecoveryPoint() {
        return this.recoveryPoint;
    }

    /**
     * <p>
     * The returned recovery point object.
     * </p>
     * 
     * @param recoveryPoint
     *        The returned recovery point object.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetRecoveryPointResult withRecoveryPoint(RecoveryPoint recoveryPoint) {
        setRecoveryPoint(recoveryPoint);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRecoveryPoint() != null)
            sb.append("RecoveryPoint: ").append(getRecoveryPoint());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetRecoveryPointResult == false)
            return false;
        GetRecoveryPointResult other = (GetRecoveryPointResult) obj;
        if (other.getRecoveryPoint() == null ^ this.getRecoveryPoint() == null)
            return false;
        if (other.getRecoveryPoint() != null && other.getRecoveryPoint().equals(this.getRecoveryPoint()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRecoveryPoint() == null) ? 0 : getRecoveryPoint().hashCode());
        return hashCode;
    }

    @Override
    public GetRecoveryPointResult clone() {
        try {
            return (GetRecoveryPointResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
