/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.amplify;

import javax.annotation.Generated;

import com.amazonaws.services.amplify.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSAmplify}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAmplify implements AWSAmplify {

    protected AbstractAWSAmplify() {
    }

    @Override
    public CreateAppResult createApp(CreateAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBackendEnvironmentResult createBackendEnvironment(CreateBackendEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBranchResult createBranch(CreateBranchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeploymentResult createDeployment(CreateDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDomainAssociationResult createDomainAssociation(CreateDomainAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWebhookResult createWebhook(CreateWebhookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppResult deleteApp(DeleteAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBackendEnvironmentResult deleteBackendEnvironment(DeleteBackendEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBranchResult deleteBranch(DeleteBranchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainAssociationResult deleteDomainAssociation(DeleteDomainAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteJobResult deleteJob(DeleteJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWebhookResult deleteWebhook(DeleteWebhookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GenerateAccessLogsResult generateAccessLogs(GenerateAccessLogsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppResult getApp(GetAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetArtifactUrlResult getArtifactUrl(GetArtifactUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBackendEnvironmentResult getBackendEnvironment(GetBackendEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBranchResult getBranch(GetBranchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDomainAssociationResult getDomainAssociation(GetDomainAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobResult getJob(GetJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWebhookResult getWebhook(GetWebhookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppsResult listApps(ListAppsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListArtifactsResult listArtifacts(ListArtifactsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBackendEnvironmentsResult listBackendEnvironments(ListBackendEnvironmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBranchesResult listBranches(ListBranchesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDomainAssociationsResult listDomainAssociations(ListDomainAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWebhooksResult listWebhooks(ListWebhooksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDeploymentResult startDeployment(StartDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartJobResult startJob(StartJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopJobResult stopJob(StopJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppResult updateApp(UpdateAppRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBranchResult updateBranch(UpdateBranchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDomainAssociationResult updateDomainAssociation(UpdateDomainAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWebhookResult updateWebhook(UpdateWebhookRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
