/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteCell"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteCellRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /** The Cell to delete */
    private String cellName;

    /**
     * The Cell to delete
     * 
     * @param cellName
     *        The Cell to delete
     */

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    /**
     * The Cell to delete
     * 
     * @return The Cell to delete
     */

    public String getCellName() {
        return this.cellName;
    }

    /**
     * The Cell to delete
     * 
     * @param cellName
     *        The Cell to delete
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteCellRequest withCellName(String cellName) {
        setCellName(cellName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCellName() != null)
            sb.append("CellName: ").append(getCellName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteCellRequest == false)
            return false;
        DeleteCellRequest other = (DeleteCellRequest) obj;
        if (other.getCellName() == null ^ this.getCellName() == null)
            return false;
        if (other.getCellName() != null && other.getCellName().equals(this.getCellName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCellName() == null) ? 0 : getCellName().hashCode());
        return hashCode;
    }

    @Override
    public DeleteCellRequest clone() {
        return (DeleteCellRequest) super.clone();
    }

}
