/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkvoice.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationAlexaSkillConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutSipMediaApplicationAlexaSkillConfigurationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements
        Serializable, Cloneable {

    private SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration;

    /**
     * @param sipMediaApplicationAlexaSkillConfiguration
     */

    public void setSipMediaApplicationAlexaSkillConfiguration(SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration) {
        this.sipMediaApplicationAlexaSkillConfiguration = sipMediaApplicationAlexaSkillConfiguration;
    }

    /**
     * @return
     */

    public SipMediaApplicationAlexaSkillConfiguration getSipMediaApplicationAlexaSkillConfiguration() {
        return this.sipMediaApplicationAlexaSkillConfiguration;
    }

    /**
     * @param sipMediaApplicationAlexaSkillConfiguration
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutSipMediaApplicationAlexaSkillConfigurationResult withSipMediaApplicationAlexaSkillConfiguration(
            SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration) {
        setSipMediaApplicationAlexaSkillConfiguration(sipMediaApplicationAlexaSkillConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSipMediaApplicationAlexaSkillConfiguration() != null)
            sb.append("SipMediaApplicationAlexaSkillConfiguration: ").append(getSipMediaApplicationAlexaSkillConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutSipMediaApplicationAlexaSkillConfigurationResult == false)
            return false;
        PutSipMediaApplicationAlexaSkillConfigurationResult other = (PutSipMediaApplicationAlexaSkillConfigurationResult) obj;
        if (other.getSipMediaApplicationAlexaSkillConfiguration() == null ^ this.getSipMediaApplicationAlexaSkillConfiguration() == null)
            return false;
        if (other.getSipMediaApplicationAlexaSkillConfiguration() != null
                && other.getSipMediaApplicationAlexaSkillConfiguration().equals(this.getSipMediaApplicationAlexaSkillConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getSipMediaApplicationAlexaSkillConfiguration() == null) ? 0 : getSipMediaApplicationAlexaSkillConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public PutSipMediaApplicationAlexaSkillConfigurationResult clone() {
        try {
            return (PutSipMediaApplicationAlexaSkillConfigurationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
