/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftserverless;

import javax.annotation.Generated;

import com.amazonaws.services.redshiftserverless.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSRedshiftServerless}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSRedshiftServerless implements AWSRedshiftServerless {

    protected AbstractAWSRedshiftServerless() {
    }

    @Override
    public ConvertRecoveryPointToSnapshotResult convertRecoveryPointToSnapshot(ConvertRecoveryPointToSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointAccessResult createEndpointAccess(CreateEndpointAccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSnapshotResult createSnapshot(CreateSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUsageLimitResult createUsageLimit(CreateUsageLimitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkgroupResult createWorkgroup(CreateWorkgroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointAccessResult deleteEndpointAccess(DeleteEndpointAccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSnapshotResult deleteSnapshot(DeleteSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUsageLimitResult deleteUsageLimit(DeleteUsageLimitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkgroupResult deleteWorkgroup(DeleteWorkgroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCredentialsResult getCredentials(GetCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEndpointAccessResult getEndpointAccess(GetEndpointAccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRecoveryPointResult getRecoveryPoint(GetRecoveryPointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourcePolicyResult getResourcePolicy(GetResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSnapshotResult getSnapshot(GetSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTableRestoreStatusResult getTableRestoreStatus(GetTableRestoreStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUsageLimitResult getUsageLimit(GetUsageLimitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkgroupResult getWorkgroup(GetWorkgroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEndpointAccessResult listEndpointAccess(ListEndpointAccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNamespacesResult listNamespaces(ListNamespacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRecoveryPointsResult listRecoveryPoints(ListRecoveryPointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSnapshotsResult listSnapshots(ListSnapshotsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTableRestoreStatusResult listTableRestoreStatus(ListTableRestoreStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUsageLimitsResult listUsageLimits(ListUsageLimitsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkgroupsResult listWorkgroups(ListWorkgroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestoreFromRecoveryPointResult restoreFromRecoveryPoint(RestoreFromRecoveryPointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestoreFromSnapshotResult restoreFromSnapshot(RestoreFromSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestoreTableFromSnapshotResult restoreTableFromSnapshot(RestoreTableFromSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointAccessResult updateEndpointAccess(UpdateEndpointAccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSnapshotResult updateSnapshot(UpdateSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUsageLimitResult updateUsageLimit(UpdateUsageLimitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkgroupResult updateWorkgroup(UpdateWorkgroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
