/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datazone.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The details about a project member.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/MemberDetails" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MemberDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The group details of a project member.
     * </p>
     */
    private GroupDetails group;
    /**
     * <p>
     * The user details of a project member.
     * </p>
     */
    private UserDetails user;

    /**
     * <p>
     * The group details of a project member.
     * </p>
     * 
     * @param group
     *        The group details of a project member.
     */

    public void setGroup(GroupDetails group) {
        this.group = group;
    }

    /**
     * <p>
     * The group details of a project member.
     * </p>
     * 
     * @return The group details of a project member.
     */

    public GroupDetails getGroup() {
        return this.group;
    }

    /**
     * <p>
     * The group details of a project member.
     * </p>
     * 
     * @param group
     *        The group details of a project member.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MemberDetails withGroup(GroupDetails group) {
        setGroup(group);
        return this;
    }

    /**
     * <p>
     * The user details of a project member.
     * </p>
     * 
     * @param user
     *        The user details of a project member.
     */

    public void setUser(UserDetails user) {
        this.user = user;
    }

    /**
     * <p>
     * The user details of a project member.
     * </p>
     * 
     * @return The user details of a project member.
     */

    public UserDetails getUser() {
        return this.user;
    }

    /**
     * <p>
     * The user details of a project member.
     * </p>
     * 
     * @param user
     *        The user details of a project member.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MemberDetails withUser(UserDetails user) {
        setUser(user);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGroup() != null)
            sb.append("Group: ").append(getGroup()).append(",");
        if (getUser() != null)
            sb.append("User: ").append(getUser());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MemberDetails == false)
            return false;
        MemberDetails other = (MemberDetails) obj;
        if (other.getGroup() == null ^ this.getGroup() == null)
            return false;
        if (other.getGroup() != null && other.getGroup().equals(this.getGroup()) == false)
            return false;
        if (other.getUser() == null ^ this.getUser() == null)
            return false;
        if (other.getUser() != null && other.getUser().equals(this.getUser()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGroup() == null) ? 0 : getGroup().hashCode());
        hashCode = prime * hashCode + ((getUser() == null) ? 0 : getUser().hashCode());
        return hashCode;
    }

    @Override
    public MemberDetails clone() {
        try {
            return (MemberDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.datazone.model.transform.MemberDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
