/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.entityresolution.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.entityresolution.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ProviderServiceSummaryMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ProviderServiceSummaryMarshaller {

    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerName").build();
    private static final MarshallingInfo<String> PROVIDERSERVICEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerServiceArn").build();
    private static final MarshallingInfo<String> PROVIDERSERVICEDISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerServiceDisplayName").build();
    private static final MarshallingInfo<String> PROVIDERSERVICENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerServiceName").build();
    private static final MarshallingInfo<String> PROVIDERSERVICETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerServiceType").build();

    private static final ProviderServiceSummaryMarshaller instance = new ProviderServiceSummaryMarshaller();

    public static ProviderServiceSummaryMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ProviderServiceSummary providerServiceSummary, ProtocolMarshaller protocolMarshaller) {

        if (providerServiceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(providerServiceSummary.getProviderName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall(providerServiceSummary.getProviderServiceArn(), PROVIDERSERVICEARN_BINDING);
            protocolMarshaller.marshall(providerServiceSummary.getProviderServiceDisplayName(), PROVIDERSERVICEDISPLAYNAME_BINDING);
            protocolMarshaller.marshall(providerServiceSummary.getProviderServiceName(), PROVIDERSERVICENAME_BINDING);
            protocolMarshaller.marshall(providerServiceSummary.getProviderServiceType(), PROVIDERSERVICETYPE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
