/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides details about the primary Amazon Web Services Region of the endpoint.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the health check used by the endpoint to determine whether failover is
     * triggered.
     * </p>
     */
    private String healthCheck;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the health check used by the endpoint to determine whether failover is
     * triggered.
     * </p>
     * 
     * @param healthCheck
     *        The Amazon Resource Name (ARN) of the health check used by the endpoint to determine whether failover is
     *        triggered.
     */

    public void setHealthCheck(String healthCheck) {
        this.healthCheck = healthCheck;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the health check used by the endpoint to determine whether failover is
     * triggered.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the health check used by the endpoint to determine whether failover is
     *         triggered.
     */

    public String getHealthCheck() {
        return this.healthCheck;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the health check used by the endpoint to determine whether failover is
     * triggered.
     * </p>
     * 
     * @param healthCheck
     *        The Amazon Resource Name (ARN) of the health check used by the endpoint to determine whether failover is
     *        triggered.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails withHealthCheck(String healthCheck) {
        setHealthCheck(healthCheck);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getHealthCheck() != null)
            sb.append("HealthCheck: ").append(getHealthCheck());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails == false)
            return false;
        AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails other = (AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails) obj;
        if (other.getHealthCheck() == null ^ this.getHealthCheck() == null)
            return false;
        if (other.getHealthCheck() != null && other.getHealthCheck().equals(this.getHealthCheck()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getHealthCheck() == null) ? 0 : getHealthCheck().hashCode());
        return hashCode;
    }

    @Override
    public AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails clone() {
        try {
            return (AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetailsMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
