/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspacesweb.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListPortalsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The portals in the list.
     * </p>
     */
    private java.util.List<PortalSummary> portals;

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used to retrieve the next page of results for this operation.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used to retrieve the next page of results for this operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListPortalsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The portals in the list.
     * </p>
     * 
     * @return The portals in the list.
     */

    public java.util.List<PortalSummary> getPortals() {
        return portals;
    }

    /**
     * <p>
     * The portals in the list.
     * </p>
     * 
     * @param portals
     *        The portals in the list.
     */

    public void setPortals(java.util.Collection<PortalSummary> portals) {
        if (portals == null) {
            this.portals = null;
            return;
        }

        this.portals = new java.util.ArrayList<PortalSummary>(portals);
    }

    /**
     * <p>
     * The portals in the list.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPortals(java.util.Collection)} or {@link #withPortals(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param portals
     *        The portals in the list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListPortalsResult withPortals(PortalSummary... portals) {
        if (this.portals == null) {
            setPortals(new java.util.ArrayList<PortalSummary>(portals.length));
        }
        for (PortalSummary ele : portals) {
            this.portals.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The portals in the list.
     * </p>
     * 
     * @param portals
     *        The portals in the list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListPortalsResult withPortals(java.util.Collection<PortalSummary> portals) {
        setPortals(portals);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getPortals() != null)
            sb.append("Portals: ").append(getPortals());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListPortalsResult == false)
            return false;
        ListPortalsResult other = (ListPortalsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getPortals() == null ^ this.getPortals() == null)
            return false;
        if (other.getPortals() != null && other.getPortals().equals(this.getPortals()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getPortals() == null) ? 0 : getPortals().hashCode());
        return hashCode;
    }

    @Override
    public ListPortalsResult clone() {
        try {
            return (ListPortalsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
