/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kafka.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteReplicator" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteReplicatorResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator.
     * </p>
     */
    private String replicatorArn;
    /**
     * <p>
     * The state of the replicator.
     * </p>
     */
    private String replicatorState;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator.
     * </p>
     * 
     * @param replicatorArn
     *        The Amazon Resource Name (ARN) of the replicator.
     */

    public void setReplicatorArn(String replicatorArn) {
        this.replicatorArn = replicatorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicator.
     */

    public String getReplicatorArn() {
        return this.replicatorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator.
     * </p>
     * 
     * @param replicatorArn
     *        The Amazon Resource Name (ARN) of the replicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteReplicatorResult withReplicatorArn(String replicatorArn) {
        setReplicatorArn(replicatorArn);
        return this;
    }

    /**
     * <p>
     * The state of the replicator.
     * </p>
     * 
     * @param replicatorState
     *        The state of the replicator.
     * @see ReplicatorState
     */

    public void setReplicatorState(String replicatorState) {
        this.replicatorState = replicatorState;
    }

    /**
     * <p>
     * The state of the replicator.
     * </p>
     * 
     * @return The state of the replicator.
     * @see ReplicatorState
     */

    public String getReplicatorState() {
        return this.replicatorState;
    }

    /**
     * <p>
     * The state of the replicator.
     * </p>
     * 
     * @param replicatorState
     *        The state of the replicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReplicatorState
     */

    public DeleteReplicatorResult withReplicatorState(String replicatorState) {
        setReplicatorState(replicatorState);
        return this;
    }

    /**
     * <p>
     * The state of the replicator.
     * </p>
     * 
     * @param replicatorState
     *        The state of the replicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReplicatorState
     */

    public DeleteReplicatorResult withReplicatorState(ReplicatorState replicatorState) {
        this.replicatorState = replicatorState.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getReplicatorArn() != null)
            sb.append("ReplicatorArn: ").append(getReplicatorArn()).append(",");
        if (getReplicatorState() != null)
            sb.append("ReplicatorState: ").append(getReplicatorState());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteReplicatorResult == false)
            return false;
        DeleteReplicatorResult other = (DeleteReplicatorResult) obj;
        if (other.getReplicatorArn() == null ^ this.getReplicatorArn() == null)
            return false;
        if (other.getReplicatorArn() != null && other.getReplicatorArn().equals(this.getReplicatorArn()) == false)
            return false;
        if (other.getReplicatorState() == null ^ this.getReplicatorState() == null)
            return false;
        if (other.getReplicatorState() != null && other.getReplicatorState().equals(this.getReplicatorState()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getReplicatorArn() == null) ? 0 : getReplicatorArn().hashCode());
        hashCode = prime * hashCode + ((getReplicatorState() == null) ? 0 : getReplicatorState().hashCode());
        return hashCode;
    }

    @Override
    public DeleteReplicatorResult clone() {
        try {
            return (DeleteReplicatorResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
