/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearch.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * The result of a <code>ListDomainMaintenances</code> request. Contains information about the requested actions.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListDomainMaintenancesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * List of the submitted maintenance actions.
     * </p>
     */
    private java.util.List<DomainMaintenanceDetails> domainMaintenances;
    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * List of the submitted maintenance actions.
     * </p>
     * 
     * @return List of the submitted maintenance actions.
     */

    public java.util.List<DomainMaintenanceDetails> getDomainMaintenances() {
        return domainMaintenances;
    }

    /**
     * <p>
     * List of the submitted maintenance actions.
     * </p>
     * 
     * @param domainMaintenances
     *        List of the submitted maintenance actions.
     */

    public void setDomainMaintenances(java.util.Collection<DomainMaintenanceDetails> domainMaintenances) {
        if (domainMaintenances == null) {
            this.domainMaintenances = null;
            return;
        }

        this.domainMaintenances = new java.util.ArrayList<DomainMaintenanceDetails>(domainMaintenances);
    }

    /**
     * <p>
     * List of the submitted maintenance actions.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDomainMaintenances(java.util.Collection)} or {@link #withDomainMaintenances(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param domainMaintenances
     *        List of the submitted maintenance actions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDomainMaintenancesResult withDomainMaintenances(DomainMaintenanceDetails... domainMaintenances) {
        if (this.domainMaintenances == null) {
            setDomainMaintenances(new java.util.ArrayList<DomainMaintenanceDetails>(domainMaintenances.length));
        }
        for (DomainMaintenanceDetails ele : domainMaintenances) {
            this.domainMaintenances.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * List of the submitted maintenance actions.
     * </p>
     * 
     * @param domainMaintenances
     *        List of the submitted maintenance actions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDomainMaintenancesResult withDomainMaintenances(java.util.Collection<DomainMaintenanceDetails> domainMaintenances) {
        setDomainMaintenances(domainMaintenances);
        return this;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @param nextToken
     *        When <code>nextToken</code> is returned, there are more results available. The value of
     *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *        token to retrieve the next page.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @param nextToken
     *        When <code>nextToken</code> is returned, there are more results available. The value of
     *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *        token to retrieve the next page.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListDomainMaintenancesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDomainMaintenances() != null)
            sb.append("DomainMaintenances: ").append(getDomainMaintenances()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListDomainMaintenancesResult == false)
            return false;
        ListDomainMaintenancesResult other = (ListDomainMaintenancesResult) obj;
        if (other.getDomainMaintenances() == null ^ this.getDomainMaintenances() == null)
            return false;
        if (other.getDomainMaintenances() != null && other.getDomainMaintenances().equals(this.getDomainMaintenances()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDomainMaintenances() == null) ? 0 : getDomainMaintenances().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListDomainMaintenancesResult clone() {
        try {
            return (ListDomainMaintenancesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
