/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Includes encryption-related information, such as the KMS key used for encrypting data at rest and whether you want
 * MSK to encrypt your data in transit.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsMskClusterClusterInfoEncryptionInfoDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsMskClusterClusterInfoEncryptionInfoDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The settings for encrypting data in transit.
     * </p>
     */
    private AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails encryptionInTransit;
    /**
     * <p>
     * The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
     * </p>
     */
    private AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails encryptionAtRest;

    /**
     * <p>
     * The settings for encrypting data in transit.
     * </p>
     * 
     * @param encryptionInTransit
     *        The settings for encrypting data in transit.
     */

    public void setEncryptionInTransit(AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails encryptionInTransit) {
        this.encryptionInTransit = encryptionInTransit;
    }

    /**
     * <p>
     * The settings for encrypting data in transit.
     * </p>
     * 
     * @return The settings for encrypting data in transit.
     */

    public AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails getEncryptionInTransit() {
        return this.encryptionInTransit;
    }

    /**
     * <p>
     * The settings for encrypting data in transit.
     * </p>
     * 
     * @param encryptionInTransit
     *        The settings for encrypting data in transit.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsMskClusterClusterInfoEncryptionInfoDetails withEncryptionInTransit(
            AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails encryptionInTransit) {
        setEncryptionInTransit(encryptionInTransit);
        return this;
    }

    /**
     * <p>
     * The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
     * </p>
     * 
     * @param encryptionAtRest
     *        The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
     */

    public void setEncryptionAtRest(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails encryptionAtRest) {
        this.encryptionAtRest = encryptionAtRest;
    }

    /**
     * <p>
     * The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
     * </p>
     * 
     * @return The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
     */

    public AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails getEncryptionAtRest() {
        return this.encryptionAtRest;
    }

    /**
     * <p>
     * The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
     * </p>
     * 
     * @param encryptionAtRest
     *        The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsMskClusterClusterInfoEncryptionInfoDetails withEncryptionAtRest(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails encryptionAtRest) {
        setEncryptionAtRest(encryptionAtRest);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEncryptionInTransit() != null)
            sb.append("EncryptionInTransit: ").append(getEncryptionInTransit()).append(",");
        if (getEncryptionAtRest() != null)
            sb.append("EncryptionAtRest: ").append(getEncryptionAtRest());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsMskClusterClusterInfoEncryptionInfoDetails == false)
            return false;
        AwsMskClusterClusterInfoEncryptionInfoDetails other = (AwsMskClusterClusterInfoEncryptionInfoDetails) obj;
        if (other.getEncryptionInTransit() == null ^ this.getEncryptionInTransit() == null)
            return false;
        if (other.getEncryptionInTransit() != null && other.getEncryptionInTransit().equals(this.getEncryptionInTransit()) == false)
            return false;
        if (other.getEncryptionAtRest() == null ^ this.getEncryptionAtRest() == null)
            return false;
        if (other.getEncryptionAtRest() != null && other.getEncryptionAtRest().equals(this.getEncryptionAtRest()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEncryptionInTransit() == null) ? 0 : getEncryptionInTransit().hashCode());
        hashCode = prime * hashCode + ((getEncryptionAtRest() == null) ? 0 : getEncryptionAtRest().hashCode());
        return hashCode;
    }

    @Override
    public AwsMskClusterClusterInfoEncryptionInfoDetails clone() {
        try {
            return (AwsMskClusterClusterInfoEncryptionInfoDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsMskClusterClusterInfoEncryptionInfoDetailsMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
