/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datazone.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectSubscriptionRequest" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RejectSubscriptionRequestRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The decision comment of the rejected subscription request.
     * </p>
     */
    private String decisionComment;
    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the subscription request was rejected.
     * </p>
     */
    private String domainIdentifier;
    /**
     * <p>
     * The identifier of the subscription request that was rejected.
     * </p>
     */
    private String identifier;

    /**
     * <p>
     * The decision comment of the rejected subscription request.
     * </p>
     * 
     * @param decisionComment
     *        The decision comment of the rejected subscription request.
     */

    public void setDecisionComment(String decisionComment) {
        this.decisionComment = decisionComment;
    }

    /**
     * <p>
     * The decision comment of the rejected subscription request.
     * </p>
     * 
     * @return The decision comment of the rejected subscription request.
     */

    public String getDecisionComment() {
        return this.decisionComment;
    }

    /**
     * <p>
     * The decision comment of the rejected subscription request.
     * </p>
     * 
     * @param decisionComment
     *        The decision comment of the rejected subscription request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RejectSubscriptionRequestRequest withDecisionComment(String decisionComment) {
        setDecisionComment(decisionComment);
        return this;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the subscription request was rejected.
     * </p>
     * 
     * @param domainIdentifier
     *        The identifier of the Amazon DataZone domain in which the subscription request was rejected.
     */

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the subscription request was rejected.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which the subscription request was rejected.
     */

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the subscription request was rejected.
     * </p>
     * 
     * @param domainIdentifier
     *        The identifier of the Amazon DataZone domain in which the subscription request was rejected.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RejectSubscriptionRequestRequest withDomainIdentifier(String domainIdentifier) {
        setDomainIdentifier(domainIdentifier);
        return this;
    }

    /**
     * <p>
     * The identifier of the subscription request that was rejected.
     * </p>
     * 
     * @param identifier
     *        The identifier of the subscription request that was rejected.
     */

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    /**
     * <p>
     * The identifier of the subscription request that was rejected.
     * </p>
     * 
     * @return The identifier of the subscription request that was rejected.
     */

    public String getIdentifier() {
        return this.identifier;
    }

    /**
     * <p>
     * The identifier of the subscription request that was rejected.
     * </p>
     * 
     * @param identifier
     *        The identifier of the subscription request that was rejected.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RejectSubscriptionRequestRequest withIdentifier(String identifier) {
        setIdentifier(identifier);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDecisionComment() != null)
            sb.append("DecisionComment: ").append("***Sensitive Data Redacted***").append(",");
        if (getDomainIdentifier() != null)
            sb.append("DomainIdentifier: ").append(getDomainIdentifier()).append(",");
        if (getIdentifier() != null)
            sb.append("Identifier: ").append(getIdentifier());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RejectSubscriptionRequestRequest == false)
            return false;
        RejectSubscriptionRequestRequest other = (RejectSubscriptionRequestRequest) obj;
        if (other.getDecisionComment() == null ^ this.getDecisionComment() == null)
            return false;
        if (other.getDecisionComment() != null && other.getDecisionComment().equals(this.getDecisionComment()) == false)
            return false;
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null)
            return false;
        if (other.getDomainIdentifier() != null && other.getDomainIdentifier().equals(this.getDomainIdentifier()) == false)
            return false;
        if (other.getIdentifier() == null ^ this.getIdentifier() == null)
            return false;
        if (other.getIdentifier() != null && other.getIdentifier().equals(this.getIdentifier()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDecisionComment() == null) ? 0 : getDecisionComment().hashCode());
        hashCode = prime * hashCode + ((getDomainIdentifier() == null) ? 0 : getDomainIdentifier().hashCode());
        hashCode = prime * hashCode + ((getIdentifier() == null) ? 0 : getIdentifier().hashCode());
        return hashCode;
    }

    @Override
    public RejectSubscriptionRequestRequest clone() {
        return (RejectSubscriptionRequestRequest) super.clone();
    }

}
