/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qbusiness;

import javax.annotation.Generated;

import com.amazonaws.services.qbusiness.model.*;

/**
 * Abstract implementation of {@code AWSQBusinessAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSQBusinessAsync extends AbstractAWSQBusiness implements AWSQBusinessAsync {

    protected AbstractAWSQBusinessAsync() {
    }

    @Override
    public java.util.concurrent.Future<BatchDeleteDocumentResult> batchDeleteDocumentAsync(BatchDeleteDocumentRequest request) {

        return batchDeleteDocumentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchDeleteDocumentResult> batchDeleteDocumentAsync(BatchDeleteDocumentRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchDeleteDocumentRequest, BatchDeleteDocumentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchPutDocumentResult> batchPutDocumentAsync(BatchPutDocumentRequest request) {

        return batchPutDocumentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchPutDocumentResult> batchPutDocumentAsync(BatchPutDocumentRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchPutDocumentRequest, BatchPutDocumentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ChatSyncResult> chatSyncAsync(ChatSyncRequest request) {

        return chatSyncAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ChatSyncResult> chatSyncAsync(ChatSyncRequest request,
            com.amazonaws.handlers.AsyncHandler<ChatSyncRequest, ChatSyncResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {

        return createApplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateIndexResult> createIndexAsync(CreateIndexRequest request) {

        return createIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateIndexResult> createIndexAsync(CreateIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateIndexRequest, CreateIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreatePluginResult> createPluginAsync(CreatePluginRequest request) {

        return createPluginAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreatePluginResult> createPluginAsync(CreatePluginRequest request,
            com.amazonaws.handlers.AsyncHandler<CreatePluginRequest, CreatePluginResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRetrieverResult> createRetrieverAsync(CreateRetrieverRequest request) {

        return createRetrieverAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRetrieverResult> createRetrieverAsync(CreateRetrieverRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRetrieverRequest, CreateRetrieverResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateUserResult> createUserAsync(CreateUserRequest request) {

        return createUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateUserResult> createUserAsync(CreateUserRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateUserRequest, CreateUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateWebExperienceResult> createWebExperienceAsync(CreateWebExperienceRequest request) {

        return createWebExperienceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateWebExperienceResult> createWebExperienceAsync(CreateWebExperienceRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateWebExperienceRequest, CreateWebExperienceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request) {

        return deleteApplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteChatControlsConfigurationResult> deleteChatControlsConfigurationAsync(
            DeleteChatControlsConfigurationRequest request) {

        return deleteChatControlsConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteChatControlsConfigurationResult> deleteChatControlsConfigurationAsync(
            DeleteChatControlsConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteChatControlsConfigurationRequest, DeleteChatControlsConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteConversationResult> deleteConversationAsync(DeleteConversationRequest request) {

        return deleteConversationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteConversationResult> deleteConversationAsync(DeleteConversationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteConversationRequest, DeleteConversationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDataSourceResult> deleteDataSourceAsync(DeleteDataSourceRequest request) {

        return deleteDataSourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDataSourceResult> deleteDataSourceAsync(DeleteDataSourceRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDataSourceRequest, DeleteDataSourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request) {

        return deleteGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteGroupRequest, DeleteGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIndexResult> deleteIndexAsync(DeleteIndexRequest request) {

        return deleteIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIndexResult> deleteIndexAsync(DeleteIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIndexRequest, DeleteIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeletePluginResult> deletePluginAsync(DeletePluginRequest request) {

        return deletePluginAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeletePluginResult> deletePluginAsync(DeletePluginRequest request,
            com.amazonaws.handlers.AsyncHandler<DeletePluginRequest, DeletePluginResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRetrieverResult> deleteRetrieverAsync(DeleteRetrieverRequest request) {

        return deleteRetrieverAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRetrieverResult> deleteRetrieverAsync(DeleteRetrieverRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRetrieverRequest, DeleteRetrieverResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {

        return deleteUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteWebExperienceResult> deleteWebExperienceAsync(DeleteWebExperienceRequest request) {

        return deleteWebExperienceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteWebExperienceResult> deleteWebExperienceAsync(DeleteWebExperienceRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteWebExperienceRequest, DeleteWebExperienceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request) {

        return getApplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetApplicationRequest, GetApplicationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetChatControlsConfigurationResult> getChatControlsConfigurationAsync(GetChatControlsConfigurationRequest request) {

        return getChatControlsConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetChatControlsConfigurationResult> getChatControlsConfigurationAsync(GetChatControlsConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetChatControlsConfigurationRequest, GetChatControlsConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDataSourceResult> getDataSourceAsync(GetDataSourceRequest request) {

        return getDataSourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDataSourceResult> getDataSourceAsync(GetDataSourceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDataSourceRequest, GetDataSourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGroupResult> getGroupAsync(GetGroupRequest request) {

        return getGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGroupResult> getGroupAsync(GetGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGroupRequest, GetGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIndexResult> getIndexAsync(GetIndexRequest request) {

        return getIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIndexResult> getIndexAsync(GetIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIndexRequest, GetIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPluginResult> getPluginAsync(GetPluginRequest request) {

        return getPluginAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPluginResult> getPluginAsync(GetPluginRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPluginRequest, GetPluginResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRetrieverResult> getRetrieverAsync(GetRetrieverRequest request) {

        return getRetrieverAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRetrieverResult> getRetrieverAsync(GetRetrieverRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRetrieverRequest, GetRetrieverResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetUserResult> getUserAsync(GetUserRequest request) {

        return getUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetUserResult> getUserAsync(GetUserRequest request,
            com.amazonaws.handlers.AsyncHandler<GetUserRequest, GetUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetWebExperienceResult> getWebExperienceAsync(GetWebExperienceRequest request) {

        return getWebExperienceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetWebExperienceResult> getWebExperienceAsync(GetWebExperienceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetWebExperienceRequest, GetWebExperienceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {

        return listApplicationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListConversationsResult> listConversationsAsync(ListConversationsRequest request) {

        return listConversationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListConversationsResult> listConversationsAsync(ListConversationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListConversationsRequest, ListConversationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDataSourceSyncJobsResult> listDataSourceSyncJobsAsync(ListDataSourceSyncJobsRequest request) {

        return listDataSourceSyncJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDataSourceSyncJobsResult> listDataSourceSyncJobsAsync(ListDataSourceSyncJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDataSourceSyncJobsRequest, ListDataSourceSyncJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDataSourcesResult> listDataSourcesAsync(ListDataSourcesRequest request) {

        return listDataSourcesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDataSourcesResult> listDataSourcesAsync(ListDataSourcesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDataSourcesRequest, ListDataSourcesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDocumentsResult> listDocumentsAsync(ListDocumentsRequest request) {

        return listDocumentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDocumentsResult> listDocumentsAsync(ListDocumentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDocumentsRequest, ListDocumentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request) {

        return listGroupsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListGroupsRequest, ListGroupsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListIndicesResult> listIndicesAsync(ListIndicesRequest request) {

        return listIndicesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListIndicesResult> listIndicesAsync(ListIndicesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListIndicesRequest, ListIndicesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMessagesResult> listMessagesAsync(ListMessagesRequest request) {

        return listMessagesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMessagesResult> listMessagesAsync(ListMessagesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMessagesRequest, ListMessagesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPluginsResult> listPluginsAsync(ListPluginsRequest request) {

        return listPluginsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPluginsResult> listPluginsAsync(ListPluginsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPluginsRequest, ListPluginsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRetrieversResult> listRetrieversAsync(ListRetrieversRequest request) {

        return listRetrieversAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRetrieversResult> listRetrieversAsync(ListRetrieversRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRetrieversRequest, ListRetrieversResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListWebExperiencesResult> listWebExperiencesAsync(ListWebExperiencesRequest request) {

        return listWebExperiencesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListWebExperiencesResult> listWebExperiencesAsync(ListWebExperiencesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListWebExperiencesRequest, ListWebExperiencesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutFeedbackResult> putFeedbackAsync(PutFeedbackRequest request) {

        return putFeedbackAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutFeedbackResult> putFeedbackAsync(PutFeedbackRequest request,
            com.amazonaws.handlers.AsyncHandler<PutFeedbackRequest, PutFeedbackResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutGroupResult> putGroupAsync(PutGroupRequest request) {

        return putGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutGroupResult> putGroupAsync(PutGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<PutGroupRequest, PutGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartDataSourceSyncJobResult> startDataSourceSyncJobAsync(StartDataSourceSyncJobRequest request) {

        return startDataSourceSyncJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartDataSourceSyncJobResult> startDataSourceSyncJobAsync(StartDataSourceSyncJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartDataSourceSyncJobRequest, StartDataSourceSyncJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopDataSourceSyncJobResult> stopDataSourceSyncJobAsync(StopDataSourceSyncJobRequest request) {

        return stopDataSourceSyncJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopDataSourceSyncJobResult> stopDataSourceSyncJobAsync(StopDataSourceSyncJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StopDataSourceSyncJobRequest, StopDataSourceSyncJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {

        return updateApplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateChatControlsConfigurationResult> updateChatControlsConfigurationAsync(
            UpdateChatControlsConfigurationRequest request) {

        return updateChatControlsConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateChatControlsConfigurationResult> updateChatControlsConfigurationAsync(
            UpdateChatControlsConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateChatControlsConfigurationRequest, UpdateChatControlsConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDataSourceResult> updateDataSourceAsync(UpdateDataSourceRequest request) {

        return updateDataSourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDataSourceResult> updateDataSourceAsync(UpdateDataSourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDataSourceRequest, UpdateDataSourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateIndexResult> updateIndexAsync(UpdateIndexRequest request) {

        return updateIndexAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateIndexResult> updateIndexAsync(UpdateIndexRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateIndexRequest, UpdateIndexResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePluginResult> updatePluginAsync(UpdatePluginRequest request) {

        return updatePluginAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePluginResult> updatePluginAsync(UpdatePluginRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePluginRequest, UpdatePluginResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateRetrieverResult> updateRetrieverAsync(UpdateRetrieverRequest request) {

        return updateRetrieverAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateRetrieverResult> updateRetrieverAsync(UpdateRetrieverRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateRetrieverRequest, UpdateRetrieverResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {

        return updateUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateWebExperienceResult> updateWebExperienceAsync(UpdateWebExperienceRequest request) {

        return updateWebExperienceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateWebExperienceResult> updateWebExperienceAsync(UpdateWebExperienceRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateWebExperienceRequest, UpdateWebExperienceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
