/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.nimblestudio;

import javax.annotation.Generated;

import com.amazonaws.services.nimblestudio.model.*;

/**
 * Abstract implementation of {@code AmazonNimbleStudioAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonNimbleStudioAsync extends AbstractAmazonNimbleStudio implements AmazonNimbleStudioAsync {

    protected AbstractAmazonNimbleStudioAsync() {
    }

    @Override
    public java.util.concurrent.Future<AcceptEulasResult> acceptEulasAsync(AcceptEulasRequest request) {

        return acceptEulasAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AcceptEulasResult> acceptEulasAsync(AcceptEulasRequest request,
            com.amazonaws.handlers.AsyncHandler<AcceptEulasRequest, AcceptEulasResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateLaunchProfileResult> createLaunchProfileAsync(CreateLaunchProfileRequest request) {

        return createLaunchProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateLaunchProfileResult> createLaunchProfileAsync(CreateLaunchProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateLaunchProfileRequest, CreateLaunchProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateStreamingImageResult> createStreamingImageAsync(CreateStreamingImageRequest request) {

        return createStreamingImageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateStreamingImageResult> createStreamingImageAsync(CreateStreamingImageRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateStreamingImageRequest, CreateStreamingImageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateStreamingSessionResult> createStreamingSessionAsync(CreateStreamingSessionRequest request) {

        return createStreamingSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateStreamingSessionResult> createStreamingSessionAsync(CreateStreamingSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateStreamingSessionRequest, CreateStreamingSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateStreamingSessionStreamResult> createStreamingSessionStreamAsync(CreateStreamingSessionStreamRequest request) {

        return createStreamingSessionStreamAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateStreamingSessionStreamResult> createStreamingSessionStreamAsync(CreateStreamingSessionStreamRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateStreamingSessionStreamRequest, CreateStreamingSessionStreamResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateStudioResult> createStudioAsync(CreateStudioRequest request) {

        return createStudioAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateStudioResult> createStudioAsync(CreateStudioRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateStudioRequest, CreateStudioResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateStudioComponentResult> createStudioComponentAsync(CreateStudioComponentRequest request) {

        return createStudioComponentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateStudioComponentResult> createStudioComponentAsync(CreateStudioComponentRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateStudioComponentRequest, CreateStudioComponentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteLaunchProfileResult> deleteLaunchProfileAsync(DeleteLaunchProfileRequest request) {

        return deleteLaunchProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteLaunchProfileResult> deleteLaunchProfileAsync(DeleteLaunchProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteLaunchProfileRequest, DeleteLaunchProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteLaunchProfileMemberResult> deleteLaunchProfileMemberAsync(DeleteLaunchProfileMemberRequest request) {

        return deleteLaunchProfileMemberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteLaunchProfileMemberResult> deleteLaunchProfileMemberAsync(DeleteLaunchProfileMemberRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteLaunchProfileMemberRequest, DeleteLaunchProfileMemberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteStreamingImageResult> deleteStreamingImageAsync(DeleteStreamingImageRequest request) {

        return deleteStreamingImageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStreamingImageResult> deleteStreamingImageAsync(DeleteStreamingImageRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteStreamingImageRequest, DeleteStreamingImageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteStreamingSessionResult> deleteStreamingSessionAsync(DeleteStreamingSessionRequest request) {

        return deleteStreamingSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStreamingSessionResult> deleteStreamingSessionAsync(DeleteStreamingSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteStreamingSessionRequest, DeleteStreamingSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteStudioResult> deleteStudioAsync(DeleteStudioRequest request) {

        return deleteStudioAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStudioResult> deleteStudioAsync(DeleteStudioRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteStudioRequest, DeleteStudioResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteStudioComponentResult> deleteStudioComponentAsync(DeleteStudioComponentRequest request) {

        return deleteStudioComponentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStudioComponentResult> deleteStudioComponentAsync(DeleteStudioComponentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteStudioComponentRequest, DeleteStudioComponentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteStudioMemberResult> deleteStudioMemberAsync(DeleteStudioMemberRequest request) {

        return deleteStudioMemberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStudioMemberResult> deleteStudioMemberAsync(DeleteStudioMemberRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteStudioMemberRequest, DeleteStudioMemberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEulaResult> getEulaAsync(GetEulaRequest request) {

        return getEulaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEulaResult> getEulaAsync(GetEulaRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEulaRequest, GetEulaResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLaunchProfileResult> getLaunchProfileAsync(GetLaunchProfileRequest request) {

        return getLaunchProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLaunchProfileResult> getLaunchProfileAsync(GetLaunchProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLaunchProfileRequest, GetLaunchProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLaunchProfileDetailsResult> getLaunchProfileDetailsAsync(GetLaunchProfileDetailsRequest request) {

        return getLaunchProfileDetailsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLaunchProfileDetailsResult> getLaunchProfileDetailsAsync(GetLaunchProfileDetailsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLaunchProfileDetailsRequest, GetLaunchProfileDetailsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLaunchProfileInitializationResult> getLaunchProfileInitializationAsync(GetLaunchProfileInitializationRequest request) {

        return getLaunchProfileInitializationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLaunchProfileInitializationResult> getLaunchProfileInitializationAsync(GetLaunchProfileInitializationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLaunchProfileInitializationRequest, GetLaunchProfileInitializationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLaunchProfileMemberResult> getLaunchProfileMemberAsync(GetLaunchProfileMemberRequest request) {

        return getLaunchProfileMemberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLaunchProfileMemberResult> getLaunchProfileMemberAsync(GetLaunchProfileMemberRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLaunchProfileMemberRequest, GetLaunchProfileMemberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStreamingImageResult> getStreamingImageAsync(GetStreamingImageRequest request) {

        return getStreamingImageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStreamingImageResult> getStreamingImageAsync(GetStreamingImageRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStreamingImageRequest, GetStreamingImageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStreamingSessionResult> getStreamingSessionAsync(GetStreamingSessionRequest request) {

        return getStreamingSessionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStreamingSessionResult> getStreamingSessionAsync(GetStreamingSessionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStreamingSessionRequest, GetStreamingSessionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStreamingSessionStreamResult> getStreamingSessionStreamAsync(GetStreamingSessionStreamRequest request) {

        return getStreamingSessionStreamAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStreamingSessionStreamResult> getStreamingSessionStreamAsync(GetStreamingSessionStreamRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStreamingSessionStreamRequest, GetStreamingSessionStreamResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStudioResult> getStudioAsync(GetStudioRequest request) {

        return getStudioAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStudioResult> getStudioAsync(GetStudioRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStudioRequest, GetStudioResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStudioComponentResult> getStudioComponentAsync(GetStudioComponentRequest request) {

        return getStudioComponentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStudioComponentResult> getStudioComponentAsync(GetStudioComponentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStudioComponentRequest, GetStudioComponentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetStudioMemberResult> getStudioMemberAsync(GetStudioMemberRequest request) {

        return getStudioMemberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStudioMemberResult> getStudioMemberAsync(GetStudioMemberRequest request,
            com.amazonaws.handlers.AsyncHandler<GetStudioMemberRequest, GetStudioMemberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEulaAcceptancesResult> listEulaAcceptancesAsync(ListEulaAcceptancesRequest request) {

        return listEulaAcceptancesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEulaAcceptancesResult> listEulaAcceptancesAsync(ListEulaAcceptancesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEulaAcceptancesRequest, ListEulaAcceptancesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEulasResult> listEulasAsync(ListEulasRequest request) {

        return listEulasAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEulasResult> listEulasAsync(ListEulasRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEulasRequest, ListEulasResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListLaunchProfileMembersResult> listLaunchProfileMembersAsync(ListLaunchProfileMembersRequest request) {

        return listLaunchProfileMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListLaunchProfileMembersResult> listLaunchProfileMembersAsync(ListLaunchProfileMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListLaunchProfileMembersRequest, ListLaunchProfileMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListLaunchProfilesResult> listLaunchProfilesAsync(ListLaunchProfilesRequest request) {

        return listLaunchProfilesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListLaunchProfilesResult> listLaunchProfilesAsync(ListLaunchProfilesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListLaunchProfilesRequest, ListLaunchProfilesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStreamingImagesResult> listStreamingImagesAsync(ListStreamingImagesRequest request) {

        return listStreamingImagesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStreamingImagesResult> listStreamingImagesAsync(ListStreamingImagesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStreamingImagesRequest, ListStreamingImagesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStreamingSessionsResult> listStreamingSessionsAsync(ListStreamingSessionsRequest request) {

        return listStreamingSessionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStreamingSessionsResult> listStreamingSessionsAsync(ListStreamingSessionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStreamingSessionsRequest, ListStreamingSessionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStudioComponentsResult> listStudioComponentsAsync(ListStudioComponentsRequest request) {

        return listStudioComponentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStudioComponentsResult> listStudioComponentsAsync(ListStudioComponentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStudioComponentsRequest, ListStudioComponentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStudioMembersResult> listStudioMembersAsync(ListStudioMembersRequest request) {

        return listStudioMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStudioMembersResult> listStudioMembersAsync(ListStudioMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStudioMembersRequest, ListStudioMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListStudiosResult> listStudiosAsync(ListStudiosRequest request) {

        return listStudiosAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStudiosResult> listStudiosAsync(ListStudiosRequest request,
            com.amazonaws.handlers.AsyncHandler<ListStudiosRequest, ListStudiosResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutLaunchProfileMembersResult> putLaunchProfileMembersAsync(PutLaunchProfileMembersRequest request) {

        return putLaunchProfileMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutLaunchProfileMembersResult> putLaunchProfileMembersAsync(PutLaunchProfileMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<PutLaunchProfileMembersRequest, PutLaunchProfileMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutStudioMembersResult> putStudioMembersAsync(PutStudioMembersRequest request) {

        return putStudioMembersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutStudioMembersResult> putStudioMembersAsync(PutStudioMembersRequest request,
            com.amazonaws.handlers.AsyncHandler<PutStudioMembersRequest, PutStudioMembersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartStudioSSOConfigurationRepairResult> startStudioSSOConfigurationRepairAsync(
            StartStudioSSOConfigurationRepairRequest request) {

        return startStudioSSOConfigurationRepairAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartStudioSSOConfigurationRepairResult> startStudioSSOConfigurationRepairAsync(
            StartStudioSSOConfigurationRepairRequest request,
            com.amazonaws.handlers.AsyncHandler<StartStudioSSOConfigurationRepairRequest, StartStudioSSOConfigurationRepairResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateLaunchProfileResult> updateLaunchProfileAsync(UpdateLaunchProfileRequest request) {

        return updateLaunchProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateLaunchProfileResult> updateLaunchProfileAsync(UpdateLaunchProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateLaunchProfileRequest, UpdateLaunchProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateLaunchProfileMemberResult> updateLaunchProfileMemberAsync(UpdateLaunchProfileMemberRequest request) {

        return updateLaunchProfileMemberAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateLaunchProfileMemberResult> updateLaunchProfileMemberAsync(UpdateLaunchProfileMemberRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateLaunchProfileMemberRequest, UpdateLaunchProfileMemberResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateStreamingImageResult> updateStreamingImageAsync(UpdateStreamingImageRequest request) {

        return updateStreamingImageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateStreamingImageResult> updateStreamingImageAsync(UpdateStreamingImageRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateStreamingImageRequest, UpdateStreamingImageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateStudioResult> updateStudioAsync(UpdateStudioRequest request) {

        return updateStudioAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateStudioResult> updateStudioAsync(UpdateStudioRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateStudioRequest, UpdateStudioResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateStudioComponentResult> updateStudioComponentAsync(UpdateStudioComponentRequest request) {

        return updateStudioComponentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateStudioComponentResult> updateStudioComponentAsync(UpdateStudioComponentRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateStudioComponentRequest, UpdateStudioComponentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
