/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cleanroomsml;

import javax.annotation.Generated;

import com.amazonaws.services.cleanroomsml.model.*;

/**
 * Abstract implementation of {@code AWSCleanRoomsMLAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSCleanRoomsMLAsync extends AbstractAWSCleanRoomsML implements AWSCleanRoomsMLAsync {

    protected AbstractAWSCleanRoomsMLAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateAudienceModelResult> createAudienceModelAsync(CreateAudienceModelRequest request) {

        return createAudienceModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAudienceModelResult> createAudienceModelAsync(CreateAudienceModelRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAudienceModelRequest, CreateAudienceModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateConfiguredAudienceModelResult> createConfiguredAudienceModelAsync(CreateConfiguredAudienceModelRequest request) {

        return createConfiguredAudienceModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateConfiguredAudienceModelResult> createConfiguredAudienceModelAsync(CreateConfiguredAudienceModelRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateConfiguredAudienceModelRequest, CreateConfiguredAudienceModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTrainingDatasetResult> createTrainingDatasetAsync(CreateTrainingDatasetRequest request) {

        return createTrainingDatasetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTrainingDatasetResult> createTrainingDatasetAsync(CreateTrainingDatasetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTrainingDatasetRequest, CreateTrainingDatasetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAudienceGenerationJobResult> deleteAudienceGenerationJobAsync(DeleteAudienceGenerationJobRequest request) {

        return deleteAudienceGenerationJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAudienceGenerationJobResult> deleteAudienceGenerationJobAsync(DeleteAudienceGenerationJobRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAudienceGenerationJobRequest, DeleteAudienceGenerationJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAudienceModelResult> deleteAudienceModelAsync(DeleteAudienceModelRequest request) {

        return deleteAudienceModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAudienceModelResult> deleteAudienceModelAsync(DeleteAudienceModelRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAudienceModelRequest, DeleteAudienceModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredAudienceModelResult> deleteConfiguredAudienceModelAsync(DeleteConfiguredAudienceModelRequest request) {

        return deleteConfiguredAudienceModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredAudienceModelResult> deleteConfiguredAudienceModelAsync(DeleteConfiguredAudienceModelRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteConfiguredAudienceModelRequest, DeleteConfiguredAudienceModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredAudienceModelPolicyResult> deleteConfiguredAudienceModelPolicyAsync(
            DeleteConfiguredAudienceModelPolicyRequest request) {

        return deleteConfiguredAudienceModelPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteConfiguredAudienceModelPolicyResult> deleteConfiguredAudienceModelPolicyAsync(
            DeleteConfiguredAudienceModelPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteConfiguredAudienceModelPolicyRequest, DeleteConfiguredAudienceModelPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTrainingDatasetResult> deleteTrainingDatasetAsync(DeleteTrainingDatasetRequest request) {

        return deleteTrainingDatasetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTrainingDatasetResult> deleteTrainingDatasetAsync(DeleteTrainingDatasetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTrainingDatasetRequest, DeleteTrainingDatasetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAudienceGenerationJobResult> getAudienceGenerationJobAsync(GetAudienceGenerationJobRequest request) {

        return getAudienceGenerationJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAudienceGenerationJobResult> getAudienceGenerationJobAsync(GetAudienceGenerationJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAudienceGenerationJobRequest, GetAudienceGenerationJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAudienceModelResult> getAudienceModelAsync(GetAudienceModelRequest request) {

        return getAudienceModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAudienceModelResult> getAudienceModelAsync(GetAudienceModelRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAudienceModelRequest, GetAudienceModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredAudienceModelResult> getConfiguredAudienceModelAsync(GetConfiguredAudienceModelRequest request) {

        return getConfiguredAudienceModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredAudienceModelResult> getConfiguredAudienceModelAsync(GetConfiguredAudienceModelRequest request,
            com.amazonaws.handlers.AsyncHandler<GetConfiguredAudienceModelRequest, GetConfiguredAudienceModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredAudienceModelPolicyResult> getConfiguredAudienceModelPolicyAsync(
            GetConfiguredAudienceModelPolicyRequest request) {

        return getConfiguredAudienceModelPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetConfiguredAudienceModelPolicyResult> getConfiguredAudienceModelPolicyAsync(
            GetConfiguredAudienceModelPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetConfiguredAudienceModelPolicyRequest, GetConfiguredAudienceModelPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTrainingDatasetResult> getTrainingDatasetAsync(GetTrainingDatasetRequest request) {

        return getTrainingDatasetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTrainingDatasetResult> getTrainingDatasetAsync(GetTrainingDatasetRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTrainingDatasetRequest, GetTrainingDatasetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAudienceExportJobsResult> listAudienceExportJobsAsync(ListAudienceExportJobsRequest request) {

        return listAudienceExportJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAudienceExportJobsResult> listAudienceExportJobsAsync(ListAudienceExportJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAudienceExportJobsRequest, ListAudienceExportJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAudienceGenerationJobsResult> listAudienceGenerationJobsAsync(ListAudienceGenerationJobsRequest request) {

        return listAudienceGenerationJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAudienceGenerationJobsResult> listAudienceGenerationJobsAsync(ListAudienceGenerationJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAudienceGenerationJobsRequest, ListAudienceGenerationJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAudienceModelsResult> listAudienceModelsAsync(ListAudienceModelsRequest request) {

        return listAudienceModelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAudienceModelsResult> listAudienceModelsAsync(ListAudienceModelsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAudienceModelsRequest, ListAudienceModelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListConfiguredAudienceModelsResult> listConfiguredAudienceModelsAsync(ListConfiguredAudienceModelsRequest request) {

        return listConfiguredAudienceModelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListConfiguredAudienceModelsResult> listConfiguredAudienceModelsAsync(ListConfiguredAudienceModelsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListConfiguredAudienceModelsRequest, ListConfiguredAudienceModelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTrainingDatasetsResult> listTrainingDatasetsAsync(ListTrainingDatasetsRequest request) {

        return listTrainingDatasetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTrainingDatasetsResult> listTrainingDatasetsAsync(ListTrainingDatasetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTrainingDatasetsRequest, ListTrainingDatasetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutConfiguredAudienceModelPolicyResult> putConfiguredAudienceModelPolicyAsync(
            PutConfiguredAudienceModelPolicyRequest request) {

        return putConfiguredAudienceModelPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutConfiguredAudienceModelPolicyResult> putConfiguredAudienceModelPolicyAsync(
            PutConfiguredAudienceModelPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<PutConfiguredAudienceModelPolicyRequest, PutConfiguredAudienceModelPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartAudienceExportJobResult> startAudienceExportJobAsync(StartAudienceExportJobRequest request) {

        return startAudienceExportJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartAudienceExportJobResult> startAudienceExportJobAsync(StartAudienceExportJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartAudienceExportJobRequest, StartAudienceExportJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartAudienceGenerationJobResult> startAudienceGenerationJobAsync(StartAudienceGenerationJobRequest request) {

        return startAudienceGenerationJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartAudienceGenerationJobResult> startAudienceGenerationJobAsync(StartAudienceGenerationJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartAudienceGenerationJobRequest, StartAudienceGenerationJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateConfiguredAudienceModelResult> updateConfiguredAudienceModelAsync(UpdateConfiguredAudienceModelRequest request) {

        return updateConfiguredAudienceModelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateConfiguredAudienceModelResult> updateConfiguredAudienceModelAsync(UpdateConfiguredAudienceModelRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateConfiguredAudienceModelRequest, UpdateConfiguredAudienceModelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
